/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ControlResponse {
    MANUAL("MANUAL"),
    AUTOMATE("AUTOMATE"),
    DEFER("DEFER"),
    IGNORE("IGNORE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ControlResponse(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlResponse fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ControlResponse.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlResponse> knownValues() {
        return Stream.of(ControlResponse.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

