/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.testng;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.events.TestCaseEvent;
import ru.yandex.qatools.allure.events.TestCaseFailureEvent;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCaseSkippedEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.events.TestSuiteStartedEvent;
import ru.yandex.qatools.allure.utils.AnnotationManager;

public class AllureTestListener
implements ITestListener {
    private Allure lifecycle = Allure.LIFECYCLE;
    private String suiteUid = UUID.randomUUID().toString();
    private Set<String> startedTestNames = Collections.newSetFromMap(new ConcurrentHashMap());

    public void onStart(ITestContext iTestContext) {
        this.getLifecycle().fire((TestSuiteEvent)new TestSuiteStartedEvent(this.suiteUid, iTestContext.getCurrentXmlTest().getSuite().getName()));
    }

    public void onFinish(ITestContext iTestContext) {
        this.getLifecycle().fire(new TestSuiteFinishedEvent(this.suiteUid));
    }

    public void onTestStart(ITestResult iTestResult) {
        String testName = this.getName(iTestResult);
        this.startedTestNames.add(testName);
        TestCaseStartedEvent event = new TestCaseStartedEvent(this.suiteUid, testName);
        AnnotationManager am = new AnnotationManager(this.getMethodAnnotations(iTestResult));
        am.update(event);
        this.getLifecycle().fire(event);
    }

    public void onTestSuccess(ITestResult iTestResult) {
        this.fireFinishTest();
    }

    public void onTestFailure(ITestResult iTestResult) {
        this.getLifecycle().fire((TestCaseEvent)new TestCaseFailureEvent().withThrowable(iTestResult.getThrowable()));
        this.fireFinishTest();
    }

    public void onTestSkipped(ITestResult iTestResult) {
        Throwable throwable;
        if (!this.startedTestNames.contains(this.getName(iTestResult))) {
            this.onTestStart(iTestResult);
        }
        if ((throwable = iTestResult.getThrowable()) == null) {
            throwable = new SkipException("The test was skipped for some reason");
        }
        this.getLifecycle().fire((TestCaseEvent)new TestCaseSkippedEvent().withThrowable(throwable));
        this.fireFinishTest();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        this.getLifecycle().fire((TestCaseEvent)new TestCaseFailureEvent().withThrowable(iTestResult.getThrowable()));
        this.fireFinishTest();
    }

    public Annotation[] getMethodAnnotations(ITestResult iTestResult) {
        return iTestResult.getMethod().getConstructorOrMethod().getMethod().getAnnotations();
    }

    private String getName(ITestResult iTestResult) {
        StringBuilder sb = new StringBuilder(iTestResult.getName());
        Object[] parameters = iTestResult.getParameters();
        if (parameters != null && parameters.length > 0) {
            sb.append("[");
            for (Object parameter : parameters) {
                sb.append(parameter).append(",");
            }
            sb.replace(sb.length() - 1, sb.length(), "]");
        }
        return sb.toString();
    }

    private void fireFinishTest() {
        this.getLifecycle().fire(new TestCaseFinishedEvent());
    }

    Allure getLifecycle() {
        return this.lifecycle;
    }

    void setLifecycle(Allure lifecycle) {
        this.lifecycle = lifecycle;
    }

    String getSuiteUid() {
        return this.suiteUid;
    }
}

