/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.adapter.AbstractWebSocketSession;

public class JettyWebSocketSession
extends AbstractWebSocketSession<Session> {
    private static final boolean directInterfaceCalls = UpgradeRequest.class.isInterface();
    private static Method getUpgradeRequest;
    private static Method getUpgradeResponse;
    private static Method getRequestURI;
    private static Method getHeaders;
    private static Method getUserPrincipal;
    private static Method getAcceptedSubProtocol;
    private static Method getExtensions;
    private String id;
    private URI uri;
    private HttpHeaders headers;
    private String acceptedProtocol;
    private List<WebSocketExtension> extensions;
    private Principal user;

    public JettyWebSocketSession(Map<String, Object> attributes) {
        this(attributes, null);
    }

    public JettyWebSocketSession(Map<String, Object> attributes, Principal user) {
        super(attributes);
        this.user = user;
    }

    @Override
    public String getId() {
        this.checkNativeSessionInitialized();
        return this.id;
    }

    @Override
    public URI getUri() {
        this.checkNativeSessionInitialized();
        return this.uri;
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        this.checkNativeSessionInitialized();
        return this.headers;
    }

    @Override
    public String getAcceptedProtocol() {
        this.checkNativeSessionInitialized();
        return this.acceptedProtocol;
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        this.checkNativeSessionInitialized();
        return this.extensions;
    }

    @Override
    public Principal getPrincipal() {
        return this.user;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getRemoteAddress();
    }

    @Override
    public void setTextMessageSizeLimit(int messageSizeLimit) {
        this.checkNativeSessionInitialized();
        ((Session)this.getNativeSession()).getPolicy().setMaxTextMessageSize(messageSizeLimit);
    }

    @Override
    public int getTextMessageSizeLimit() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getPolicy().getMaxTextMessageSize();
    }

    @Override
    public void setBinaryMessageSizeLimit(int messageSizeLimit) {
        this.checkNativeSessionInitialized();
        ((Session)this.getNativeSession()).getPolicy().setMaxBinaryMessageSize(messageSizeLimit);
    }

    @Override
    public int getBinaryMessageSizeLimit() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getPolicy().getMaxBinaryMessageSize();
    }

    @Override
    public boolean isOpen() {
        return this.getNativeSession() != null && ((Session)this.getNativeSession()).isOpen();
    }

    @Override
    public void initializeNativeSession(Session session) {
        super.initializeNativeSession(session);
        if (directInterfaceCalls) {
            this.initializeJettySessionDirectly(session);
        } else {
            this.initializeJettySessionReflectively(session);
        }
    }

    private void initializeJettySessionDirectly(Session session) {
        this.id = ObjectUtils.getIdentityHexString(this.getNativeSession());
        this.uri = session.getUpgradeRequest().getRequestURI();
        HttpHeaders headers = new HttpHeaders();
        headers.putAll(session.getUpgradeRequest().getHeaders());
        this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
        this.acceptedProtocol = session.getUpgradeResponse().getAcceptedSubProtocol();
        List jettyExtensions = session.getUpgradeResponse().getExtensions();
        if (!CollectionUtils.isEmpty((Collection)jettyExtensions)) {
            ArrayList<WebSocketExtension> extensions = new ArrayList<WebSocketExtension>(jettyExtensions.size());
            for (ExtensionConfig jettyExtension : jettyExtensions) {
                extensions.add(new WebSocketExtension(jettyExtension.getName(), jettyExtension.getParameters()));
            }
            this.extensions = Collections.unmodifiableList(extensions);
        } else {
            this.extensions = Collections.emptyList();
        }
        if (this.user == null) {
            this.user = session.getUpgradeRequest().getUserPrincipal();
        }
    }

    private void initializeJettySessionReflectively(Session session) {
        Object request = ReflectionUtils.invokeMethod((Method)getUpgradeRequest, (Object)session);
        Object response = ReflectionUtils.invokeMethod((Method)getUpgradeResponse, (Object)session);
        this.id = ObjectUtils.getIdentityHexString(this.getNativeSession());
        this.uri = (URI)ReflectionUtils.invokeMethod((Method)getRequestURI, (Object)request);
        HttpHeaders headers = new HttpHeaders();
        headers.putAll((Map)ReflectionUtils.invokeMethod((Method)getHeaders, (Object)request));
        this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
        this.acceptedProtocol = (String)ReflectionUtils.invokeMethod((Method)getAcceptedSubProtocol, (Object)response);
        List jettyExtensions = (List)ReflectionUtils.invokeMethod((Method)getExtensions, (Object)response);
        if (!CollectionUtils.isEmpty((Collection)jettyExtensions)) {
            ArrayList<WebSocketExtension> extensions = new ArrayList<WebSocketExtension>(jettyExtensions.size());
            for (ExtensionConfig jettyExtension : jettyExtensions) {
                extensions.add(new WebSocketExtension(jettyExtension.getName(), jettyExtension.getParameters()));
            }
            this.extensions = Collections.unmodifiableList(extensions);
        } else {
            this.extensions = Collections.emptyList();
        }
        if (this.user == null) {
            this.user = (Principal)ReflectionUtils.invokeMethod((Method)getUserPrincipal, (Object)request);
        }
    }

    @Override
    protected void sendTextMessage(TextMessage message) throws IOException {
        this.getRemoteEndpoint().sendString((String)message.getPayload());
    }

    @Override
    protected void sendBinaryMessage(BinaryMessage message) throws IOException {
        this.getRemoteEndpoint().sendBytes((ByteBuffer)message.getPayload());
    }

    @Override
    protected void sendPingMessage(PingMessage message) throws IOException {
        this.getRemoteEndpoint().sendPing((ByteBuffer)message.getPayload());
    }

    @Override
    protected void sendPongMessage(PongMessage message) throws IOException {
        this.getRemoteEndpoint().sendPong((ByteBuffer)message.getPayload());
    }

    private RemoteEndpoint getRemoteEndpoint() throws IOException {
        try {
            return ((Session)this.getNativeSession()).getRemote();
        }
        catch (WebSocketException ex) {
            throw new IOException("Unable to obtain RemoteEndpoint in session " + this.getId(), ex);
        }
    }

    @Override
    protected void closeInternal(CloseStatus status) throws IOException {
        ((Session)this.getNativeSession()).close(status.getCode(), status.getReason());
    }

    static {
        if (!directInterfaceCalls) {
            try {
                getUpgradeRequest = Session.class.getMethod("getUpgradeRequest", new Class[0]);
                getUpgradeResponse = Session.class.getMethod("getUpgradeResponse", new Class[0]);
                getRequestURI = UpgradeRequest.class.getMethod("getRequestURI", new Class[0]);
                getHeaders = UpgradeRequest.class.getMethod("getHeaders", new Class[0]);
                getUserPrincipal = UpgradeRequest.class.getMethod("getUserPrincipal", new Class[0]);
                getAcceptedSubProtocol = UpgradeResponse.class.getMethod("getAcceptedSubProtocol", new Class[0]);
                getExtensions = UpgradeResponse.class.getMethod("getExtensions", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Incompatible Jetty API", ex);
            }
        }
    }
}

