/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;

public class ControllerAdviceBean
implements Ordered {
    private final Object bean;
    private final BeanFactory beanFactory;
    private final int order;
    private final Set<String> basePackages;
    private final List<Class<?>> assignableTypes;
    private final List<Class<? extends Annotation>> annotations;

    public ControllerAdviceBean(Object bean) {
        this(bean, null);
    }

    public ControllerAdviceBean(String beanName, BeanFactory beanFactory) {
        this((Object)beanName, beanFactory);
    }

    private ControllerAdviceBean(Object bean, BeanFactory beanFactory) {
        Class beanType;
        this.bean = bean;
        this.beanFactory = beanFactory;
        if (bean instanceof String) {
            String beanName = (String)bean;
            Assert.hasText((String)beanName, (String)"Bean name must not be null");
            Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
            if (!beanFactory.containsBean(beanName)) {
                throw new IllegalArgumentException("BeanFactory [" + beanFactory + "] does not contain specified controller advice bean '" + beanName + "'");
            }
            beanType = this.beanFactory.getType(beanName);
            this.order = ControllerAdviceBean.initOrderFromBeanType(beanType);
        } else {
            Assert.notNull((Object)bean, (String)"Bean must not be null");
            beanType = bean.getClass();
            this.order = ControllerAdviceBean.initOrderFromBean(bean);
        }
        ControllerAdvice annotation = (ControllerAdvice)AnnotationUtils.findAnnotation(beanType, ControllerAdvice.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Bean type [" + beanType.getName() + "] is not annotated as @ControllerAdvice");
        }
        this.basePackages = ControllerAdviceBean.initBasePackages(annotation);
        this.assignableTypes = Arrays.asList(annotation.assignableTypes());
        this.annotations = Arrays.asList(annotation.annotations());
    }

    public int getOrder() {
        return this.order;
    }

    public Class<?> getBeanType() {
        Class clazz = this.bean instanceof String ? this.beanFactory.getType((String)this.bean) : this.bean.getClass();
        return ClassUtils.getUserClass((Class)clazz);
    }

    public Object resolveBean() {
        return this.bean instanceof String ? this.beanFactory.getBean((String)this.bean) : this.bean;
    }

    public boolean isApplicableToBeanType(Class<?> beanType) {
        if (!this.hasSelectors()) {
            return true;
        }
        if (beanType != null) {
            for (String string : this.basePackages) {
                if (!beanType.getName().startsWith(string)) continue;
                return true;
            }
            for (Class clazz : this.assignableTypes) {
                if (!ClassUtils.isAssignable((Class)clazz, beanType)) continue;
                return true;
            }
            for (Class clazz : this.annotations) {
                if (AnnotationUtils.findAnnotation(beanType, (Class)clazz) == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSelectors() {
        return !this.basePackages.isEmpty() || !this.assignableTypes.isEmpty() || !this.annotations.isEmpty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ControllerAdviceBean)) {
            return false;
        }
        ControllerAdviceBean otherAdvice = (ControllerAdviceBean)other;
        return this.bean.equals(otherAdvice.bean) && this.beanFactory == otherAdvice.beanFactory;
    }

    public int hashCode() {
        return this.bean.hashCode();
    }

    public String toString() {
        return this.bean.toString();
    }

    public static List<ControllerAdviceBean> findAnnotatedBeans(ApplicationContext applicationContext) {
        ArrayList<ControllerAdviceBean> beans = new ArrayList<ControllerAdviceBean>();
        for (String name : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)applicationContext, Object.class)) {
            if (applicationContext.findAnnotationOnBean(name, ControllerAdvice.class) == null) continue;
            beans.add(new ControllerAdviceBean(name, (BeanFactory)applicationContext));
        }
        return beans;
    }

    private static int initOrderFromBean(Object bean) {
        return bean instanceof Ordered ? ((Ordered)bean).getOrder() : ControllerAdviceBean.initOrderFromBeanType(bean.getClass());
    }

    private static int initOrderFromBeanType(Class<?> beanType) {
        return OrderUtils.getOrder(beanType, (Integer)Integer.MAX_VALUE);
    }

    private static Set<String> initBasePackages(ControllerAdvice annotation) {
        LinkedHashSet<String> basePackages = new LinkedHashSet<String>();
        for (String basePackage : annotation.value()) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            basePackages.add(ControllerAdviceBean.adaptBasePackage(basePackage));
        }
        for (String basePackage : annotation.basePackages()) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            basePackages.add(ControllerAdviceBean.adaptBasePackage(basePackage));
        }
        for (Class<?> markerClass : annotation.basePackageClasses()) {
            basePackages.add(ControllerAdviceBean.adaptBasePackage(ClassUtils.getPackageName((Class)markerClass)));
        }
        return basePackages;
    }

    private static String adaptBasePackage(String basePackage) {
        return basePackage.endsWith(".") ? basePackage : basePackage + ".";
    }
}

