/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

final class BearerTokenRequestMatcher
implements RequestMatcher {
    private final BearerTokenResolver bearerTokenResolver;

    BearerTokenRequestMatcher(BearerTokenResolver bearerTokenResolver) {
        Assert.notNull((Object)bearerTokenResolver, (String)"bearerTokenResolver cannot be null");
        this.bearerTokenResolver = bearerTokenResolver;
    }

    public boolean matches(HttpServletRequest request) {
        try {
            return this.bearerTokenResolver.resolve(request) != null;
        }
        catch (OAuth2AuthenticationException e) {
            return false;
        }
    }
}

