/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.switcher;

import javax.servlet.http.HttpServletRequest;
import org.springframework.mobile.device.switcher.AbstractSitePathUrlFactory;
import org.springframework.mobile.device.switcher.SiteUrlFactory;

public class NormalSitePathUrlFactory
extends AbstractSitePathUrlFactory
implements SiteUrlFactory {
    public NormalSitePathUrlFactory(String mobilePath) {
        this(mobilePath, null, null);
    }

    public NormalSitePathUrlFactory(String mobilePath, String rootPath) {
        this(mobilePath, null, rootPath);
    }

    public NormalSitePathUrlFactory(String mobilePath, String tabletPath, String rootPath) {
        super(mobilePath, tabletPath, rootPath);
    }

    public boolean isRequestForSite(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (this.hasMobilePath() && (requestURI.startsWith(this.getFullMobilePath()) || requestURI.equals(this.getCleanMobilePath()))) {
            return false;
        }
        return !this.hasTabletPath() || !requestURI.startsWith(this.getFullTabletPath()) && !requestURI.equals(this.getCleanTabletPath());
    }

    public String createSiteUrl(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String adjustedRequestURI = "";
        if (this.hasMobilePath() && requestURI.equals(this.getCleanMobilePath()) || this.hasTabletPath() && requestURI.equals(this.getCleanTabletPath())) {
            if (this.hasRootPath()) {
                adjustedRequestURI = this.getCleanRootPath();
            }
        } else if (this.hasMobilePath() && requestURI.startsWith(this.getFullMobilePath())) {
            adjustedRequestURI = this.hasRootPath() ? this.getRootPath() + requestURI.substring(this.getFullMobilePath().length()) : requestURI.substring(this.getCleanMobilePath().length());
        } else if (this.hasTabletPath() && requestURI.startsWith(this.getFullTabletPath())) {
            adjustedRequestURI = this.hasRootPath() ? this.getRootPath() + requestURI.substring(this.getFullTabletPath().length()) : requestURI.substring(this.getCleanTabletPath().length());
        }
        return this.createSiteUrlInternal(request, request.getServerName(), adjustedRequestURI);
    }
}

