/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.LinkedHashMap;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareBatchErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;

public class SeekToCurrentBatchErrorHandler
implements ContainerAwareBatchErrorHandler {
    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container) {
        LinkedHashMap<TopicPartition, Long> offsets = new LinkedHashMap<TopicPartition, Long>();
        data.forEach(r -> offsets.computeIfAbsent(new TopicPartition(r.topic(), r.partition()), k -> r.offset()));
        offsets.forEach((arg_0, arg_1) -> consumer.seek(arg_0, arg_1));
        throw new KafkaException("Seek to current after exception", thrownException);
    }
}

