/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.core.serializer.Deserializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.util.StreamUtils;

public class ByteArrayElasticRawDeserializer
implements Deserializer<byte[]> {
    private final int initialBufferSize;

    public ByteArrayElasticRawDeserializer() {
        this(32);
    }

    public ByteArrayElasticRawDeserializer(int initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
    }

    public byte[] deserialize(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.initialBufferSize);
        if (StreamUtils.copy((InputStream)inputStream, (OutputStream)out) == 0) {
            throw new SoftEndOfStreamException("Stream closed with no data");
        }
        out.close();
        return out.toByteArray();
    }
}

