/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.gateway;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.session.FtpFileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpOutboundGateway
extends AbstractRemoteFileOutboundGateway<FTPFile> {
    public FtpOutboundGateway(SessionFactory<FTPFile> sessionFactory, String command, String expression) {
        super(sessionFactory, command, expression);
    }

    protected boolean isDirectory(FTPFile file) {
        return file.isDirectory();
    }

    protected boolean isLink(FTPFile file) {
        return file.isSymbolicLink();
    }

    protected String getFilename(FTPFile file) {
        return file.getName();
    }

    protected long getModified(FTPFile file) {
        return file.getTimestamp().getTimeInMillis();
    }

    protected List<AbstractFileInfo<FTPFile>> asFileInfoList(Collection<FTPFile> files) {
        ArrayList<AbstractFileInfo<FTPFile>> canonicalFiles = new ArrayList<AbstractFileInfo<FTPFile>>();
        for (FTPFile file : files) {
            canonicalFiles.add(new FtpFileInfo(file));
        }
        return canonicalFiles;
    }
}

