/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.util.Collection;
import java.util.Collections;
import org.springframework.hateoas.IanaRels;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.util.Assert;

public class DefaultCurieProvider
implements CurieProvider {
    private final Curie curie;

    public DefaultCurieProvider(String name, UriTemplate uriTemplate) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.notNull((Object)uriTemplate, (String)"UriTemplate must not be null!");
        Assert.isTrue((uriTemplate.getVariableNames().size() == 1 ? 1 : 0) != 0, (String)String.format("Expected a single template variable in the UriTemplate %s!", uriTemplate.toString()));
        this.curie = new Curie(name, uriTemplate.toString());
    }

    @Override
    public Collection<? extends Object> getCurieInformation(Links links) {
        return Collections.singleton(this.curie);
    }

    @Override
    public String getNamespacedRelFrom(Link link) {
        String rel = link.getRel();
        boolean prefixingNeeded = !IanaRels.isIanaRel(rel) && !rel.contains(":");
        return prefixingNeeded ? String.format("%s:%s", this.curie.name, rel) : rel;
    }

    protected static class Curie
    extends Link {
        private static final long serialVersionUID = 1L;
        private final String name;

        public Curie(String name, String href) {
            super(href, "curies");
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

