/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.connection.stream.StreamSerialization;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface MapRecord<S, K, V>
extends Record<S, Map<K, V>>,
Iterable<Map.Entry<K, V>> {
    public static <S, K, V> MapRecord<S, K, V> create(S stream, Map<K, V> map) {
        Assert.notNull(stream, (String)"Stream must not be null");
        Assert.notNull(map, (String)"Map must not be null");
        return new StreamRecords.MapBackedRecord<S, K, V>(stream, RecordId.autoGenerate(), map);
    }

    public MapRecord<S, K, V> withId(RecordId var1);

    public <SK> MapRecord<SK, K, V> withStreamKey(SK var1);

    default public <HK, HV> MapRecord<S, HK, HV> mapEntries(Function<Map.Entry<K, V>, Map.Entry<HK, HV>> mapFunction) {
        LinkedHashMap mapped = new LinkedHashMap();
        this.iterator().forEachRemaining(it -> {
            Map.Entry mappedPair = (Map.Entry)mapFunction.apply((Map.Entry)it);
            mapped.put(mappedPair.getKey(), mappedPair.getValue());
        });
        return StreamRecords.newRecord().in(this.getStream()).withId(this.getId()).ofMap(mapped);
    }

    default public <SK, HK, HV> MapRecord<SK, HK, HV> map(Function<MapRecord<S, K, V>, MapRecord<SK, HK, HV>> mapFunction) {
        return mapFunction.apply(this);
    }

    default public ByteRecord serialize(@Nullable RedisSerializer<?> serializer) {
        return this.serialize(serializer, serializer, serializer);
    }

    default public ByteRecord serialize(@Nullable RedisSerializer<? super S> streamSerializer, @Nullable RedisSerializer<? super K> fieldSerializer, @Nullable RedisSerializer<? super V> valueSerializer) {
        MapRecord binaryMap = this.mapEntries(it -> Collections.singletonMap(StreamSerialization.serialize(fieldSerializer, it.getKey()), StreamSerialization.serialize(valueSerializer, it.getValue())).entrySet().iterator().next());
        return StreamRecords.newRecord().in(streamSerializer != null ? streamSerializer.serialize(this.getStream()) : (byte[])this.getStream()).withId(this.getId()).ofBytes((Map)binaryMap.getValue());
    }

    default public <OV> ObjectRecord<S, OV> toObjectRecord(HashMapper<? super OV, ? super K, ? super V> mapper) {
        return Record.of(mapper.fromHash((Map)this.getValue())).withId(this.getId()).withStreamKey(this.getStream());
    }
}

