/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.data.repository.core.support.MethodLookup;
import org.springframework.data.repository.core.support.MethodLookups;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class RepositoryComposition {
    private static final BiFunction<Method, Object[], Object[]> PASSTHRU_ARG_CONVERTER = (methodParameter, o) -> o;
    private static final RepositoryComposition EMPTY = new RepositoryComposition(RepositoryFragments.empty(), MethodLookups.direct(), PASSTHRU_ARG_CONVERTER);
    private final Map<Method, Optional<Method>> methodCache = new ConcurrentReferenceHashMap();
    private final RepositoryFragments fragments;
    private final MethodLookup methodLookup;
    private final BiFunction<Method, Object[], Object[]> argumentConverter;

    public static RepositoryComposition empty() {
        return EMPTY;
    }

    public static RepositoryComposition just(Object implementation) {
        return new RepositoryComposition(RepositoryFragments.just(implementation), MethodLookups.direct(), PASSTHRU_ARG_CONVERTER);
    }

    public static RepositoryComposition of(RepositoryFragment<?> ... fragments) {
        return RepositoryComposition.of(Arrays.asList(fragments));
    }

    public static RepositoryComposition of(List<RepositoryFragment<?>> fragments) {
        return new RepositoryComposition(RepositoryFragments.from(fragments), MethodLookups.direct(), PASSTHRU_ARG_CONVERTER);
    }

    public static RepositoryComposition of(RepositoryFragments fragments) {
        return new RepositoryComposition(fragments, MethodLookups.direct(), PASSTHRU_ARG_CONVERTER);
    }

    public RepositoryComposition append(RepositoryFragment<?> fragment) {
        return new RepositoryComposition(this.fragments.append(fragment), this.methodLookup, this.argumentConverter);
    }

    public RepositoryComposition append(RepositoryFragments fragments) {
        return new RepositoryComposition(this.fragments.append(fragments), this.methodLookup, this.argumentConverter);
    }

    public RepositoryComposition withArgumentConverter(BiFunction<Method, Object[], Object[]> argumentConverter) {
        return new RepositoryComposition(this.fragments, this.methodLookup, argumentConverter);
    }

    public RepositoryComposition withMethodLookup(MethodLookup methodLookup) {
        return new RepositoryComposition(this.fragments, methodLookup, this.argumentConverter);
    }

    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    public Object invoke(Method method, Object ... args) throws Throwable {
        Method methodToCall = this.findMethod(method).orElseThrow(() -> new IllegalArgumentException(String.format("No fragment found for method %s", method)));
        ReflectionUtils.makeAccessible((Method)methodToCall);
        return this.fragments.invoke(methodToCall, this.argumentConverter.apply(methodToCall, args));
    }

    public Optional<Method> findMethod(Method method) {
        return this.methodCache.computeIfAbsent(method, key -> RepositoryFragments.findMethod(MethodLookup.InvokedMethod.of(key), this.methodLookup, this.fragments::methods));
    }

    public void validateImplementation() {
        this.fragments.stream().forEach(it -> it.getImplementation().orElseThrow(() -> new IllegalStateException(String.format("Fragment %s has no implementation.", ClassUtils.getQualifiedName(it.getSignatureContributor())))));
    }

    @Generated
    private RepositoryComposition(RepositoryFragments fragments, MethodLookup methodLookup, BiFunction<Method, Object[], Object[]> argumentConverter) {
        this.fragments = fragments;
        this.methodLookup = methodLookup;
        this.argumentConverter = argumentConverter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryComposition)) {
            return false;
        }
        RepositoryComposition other = (RepositoryComposition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RepositoryFragments this$fragments = this.getFragments();
        RepositoryFragments other$fragments = other.getFragments();
        return !(this$fragments == null ? other$fragments != null : !((Object)this$fragments).equals(other$fragments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RepositoryComposition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RepositoryFragments $fragments = this.getFragments();
        result = result * 59 + ($fragments == null ? 43 : ((Object)$fragments).hashCode());
        return result;
    }

    @Generated
    public RepositoryFragments getFragments() {
        return this.fragments;
    }

    @Generated
    public MethodLookup getMethodLookup() {
        return this.methodLookup;
    }

    @Generated
    public BiFunction<Method, Object[], Object[]> getArgumentConverter() {
        return this.argumentConverter;
    }

    public static class RepositoryFragments
    implements Streamable<RepositoryFragment<?>> {
        static final RepositoryFragments EMPTY = new RepositoryFragments(Collections.emptyList());
        private final Map<Method, RepositoryFragment<?>> fragmentCache = new ConcurrentReferenceHashMap();
        private final List<RepositoryFragment<?>> fragments;

        public static RepositoryFragments empty() {
            return EMPTY;
        }

        public static RepositoryFragments just(Object ... implementations) {
            Assert.notNull((Object)implementations, (String)"Implementations must not be null!");
            Assert.noNullElements((Object[])implementations, (String)"Implementations must not contain null elements!");
            return new RepositoryFragments(Arrays.stream(implementations).map(RepositoryFragment::implemented).collect(Collectors.toList()));
        }

        public static RepositoryFragments of(RepositoryFragment<?> ... fragments) {
            Assert.notNull(fragments, (String)"RepositoryFragments must not be null!");
            Assert.noNullElements((Object[])fragments, (String)"RepositoryFragments must not contain null elements!");
            return new RepositoryFragments(Arrays.asList(fragments));
        }

        public static RepositoryFragments from(List<RepositoryFragment<?>> fragments) {
            Assert.notNull(fragments, (String)"RepositoryFragments must not be null!");
            return new RepositoryFragments(new ArrayList(fragments));
        }

        public RepositoryFragments append(RepositoryFragment<?> fragment) {
            Assert.notNull(fragment, (String)"RepositoryFragment must not be null!");
            return RepositoryFragments.concat(this.stream(), Stream.of(fragment));
        }

        public RepositoryFragments append(RepositoryFragments fragments) {
            Assert.notNull((Object)fragments, (String)"RepositoryFragments must not be null!");
            return RepositoryFragments.concat(this.stream(), fragments.stream());
        }

        private static RepositoryFragments concat(Stream<RepositoryFragment<?>> left, Stream<RepositoryFragment<?>> right) {
            return RepositoryFragments.from(Stream.concat(left, right).collect(Collectors.toList()));
        }

        public boolean isEmpty() {
            return this.fragments.isEmpty();
        }

        @Override
        public Iterator<RepositoryFragment<?>> iterator() {
            return this.fragments.iterator();
        }

        @Override
        public Stream<RepositoryFragment<?>> stream() {
            return this.fragments.stream();
        }

        public Stream<Method> methods() {
            return this.stream().flatMap(RepositoryFragment::methods);
        }

        public Object invoke(Method method, Object[] args) throws Throwable {
            RepositoryFragment fragment = this.fragmentCache.computeIfAbsent(method, key -> this.stream().filter(it -> it.hasMethod((Method)key)).filter(it -> it.getImplementation().isPresent()).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No fragment found for method %s", key))));
            Object target = fragment.getImplementation().orElseThrow(() -> new IllegalArgumentException(String.format("No implementation found for method %s", method)));
            return method.invoke(target, args);
        }

        private static Optional<Method> findMethod(MethodLookup.InvokedMethod invokedMethod, MethodLookup lookup, Supplier<Stream<Method>> methodStreamSupplier) {
            for (MethodLookup.MethodPredicate methodPredicate : lookup.getLookups()) {
                Optional<Method> resolvedMethod = methodStreamSupplier.get().filter(it -> methodPredicate.test(invokedMethod, (Method)it)).findFirst();
                if (!resolvedMethod.isPresent()) continue;
                return resolvedMethod;
            }
            return Optional.empty();
        }

        public String toString() {
            return this.fragments.toString();
        }

        @Generated
        private RepositoryFragments(List<RepositoryFragment<?>> fragments) {
            this.fragments = fragments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepositoryFragments)) {
                return false;
            }
            RepositoryFragments other = (RepositoryFragments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Method, RepositoryFragment<?>> this$fragmentCache = this.fragmentCache;
            Map<Method, RepositoryFragment<?>> other$fragmentCache = other.fragmentCache;
            if (this$fragmentCache == null ? other$fragmentCache != null : !((Object)this$fragmentCache).equals(other$fragmentCache)) {
                return false;
            }
            List<RepositoryFragment<?>> this$fragments = this.fragments;
            List<RepositoryFragment<?>> other$fragments = other.fragments;
            return !(this$fragments == null ? other$fragments != null : !((Object)this$fragments).equals(other$fragments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RepositoryFragments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Method, RepositoryFragment<?>> $fragmentCache = this.fragmentCache;
            result = result * 59 + ($fragmentCache == null ? 43 : ((Object)$fragmentCache).hashCode());
            List<RepositoryFragment<?>> $fragments = this.fragments;
            result = result * 59 + ($fragments == null ? 43 : ((Object)$fragments).hashCode());
            return result;
        }
    }
}

