/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2.sender;

import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.sender.LoadBalancerClientZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.sender.RestTemplateSender;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinRestTemplateWrapper;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinSenderCondition;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinUrlExtractor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.Sender;

@Configuration
@ConditionalOnMissingBean(value={Sender.class})
@Conditional(value={ZipkinSenderCondition.class})
class ZipkinRestTemplateSenderConfiguration {
    @Autowired
    ZipkinUrlExtractor extractor;

    ZipkinRestTemplateSenderConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public Sender restTemplateSender(ZipkinProperties zipkin, ZipkinRestTemplateCustomizer zipkinRestTemplateCustomizer) {
        ZipkinRestTemplateWrapper restTemplate = new ZipkinRestTemplateWrapper(zipkin, this.extractor);
        zipkinRestTemplateCustomizer.customize(restTemplate);
        return new RestTemplateSender(restTemplate, zipkin.getBaseUrl(), (BytesEncoder<Span>)zipkin.getEncoder());
    }

    @Bean
    ZipkinUrlExtractor zipkinUrlExtractor(final ZipkinLoadBalancer zipkinLoadBalancer) {
        return new ZipkinUrlExtractor(){

            @Override
            public URI zipkinUrl(ZipkinProperties zipkinProperties) {
                return zipkinLoadBalancer.instance();
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={LoadBalancerClient.class})
    static class DiscoveryClientZipkinUrlExtractorConfiguration {
        @Autowired(required=false)
        LoadBalancerClient client;

        DiscoveryClientZipkinUrlExtractorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinLoadBalancer loadBalancerClientZipkinLoadBalancer(ZipkinProperties zipkinProperties) {
            return new LoadBalancerClientZipkinLoadBalancer(this.client, zipkinProperties);
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.client.loadbalancer.LoadBalancerClient"})
    static class DefaultZipkinUrlExtractorConfiguration {
        @Autowired(required=false)
        LoadBalancerClient client;

        DefaultZipkinUrlExtractorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinLoadBalancer noOpLoadBalancer(final ZipkinProperties zipkinProperties) {
            return new ZipkinLoadBalancer(){

                @Override
                public URI instance() {
                    return URI.create(zipkinProperties.getBaseUrl());
                }
            };
        }
    }
}

