/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.proxy;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.security.oauth2.proxy.ProxyAuthenticationProperties;

public class AuthenticationHeaderFilter
extends ZuulFilter {
    private Map<String, ProxyAuthenticationProperties.Route> routes = new HashMap<String, ProxyAuthenticationProperties.Route>();
    private ProxyRequestHelper helper;

    public AuthenticationHeaderFilter(ProxyRequestHelper helper, ProxyAuthenticationProperties properties) {
        this.helper = helper;
        this.routes = properties.getRoutes();
    }

    public int filterOrder() {
        return 9;
    }

    public String filterType() {
        return "pre";
    }

    public boolean shouldFilter() {
        String id;
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.containsKey((Object)"proxy") && this.routes.containsKey(id = (String)ctx.get((Object)"proxy")) && ProxyAuthenticationProperties.Route.Scheme.NONE.matches(this.routes.get(id).getScheme());
    }

    public Object run() {
        this.helper.addIgnoredHeaders(new String[]{"authorization"});
        return null;
    }
}

