/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="spring.cache")
public class CacheProperties {
    private CacheType type;
    private List<String> cacheNames = new ArrayList<String>();
    private final Caffeine caffeine = new Caffeine();
    private final Couchbase couchbase = new Couchbase();
    private final EhCache ehcache = new EhCache();
    private final Hazelcast hazelcast = new Hazelcast();
    private final Infinispan infinispan = new Infinispan();
    private final JCache jcache = new JCache();
    private final Guava guava = new Guava();

    public CacheType getType() {
        return this.type;
    }

    public void setType(CacheType mode) {
        this.type = mode;
    }

    public List<String> getCacheNames() {
        return this.cacheNames;
    }

    public void setCacheNames(List<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public Caffeine getCaffeine() {
        return this.caffeine;
    }

    public Couchbase getCouchbase() {
        return this.couchbase;
    }

    public EhCache getEhcache() {
        return this.ehcache;
    }

    public Hazelcast getHazelcast() {
        return this.hazelcast;
    }

    public Infinispan getInfinispan() {
        return this.infinispan;
    }

    public JCache getJcache() {
        return this.jcache;
    }

    public Guava getGuava() {
        return this.guava;
    }

    public Resource resolveConfigLocation(Resource config) {
        if (config != null) {
            Assert.isTrue((boolean)config.exists(), (String)("Cache configuration does not exist '" + config.getDescription() + "'"));
            return config;
        }
        return null;
    }

    public static class Guava {
        private String spec;

        @Deprecated
        @DeprecatedConfigurationProperty(reason="Caffeine will supersede the Guava support in Spring Boot 2.0", replacement="spring.cache.caffeine.spec")
        public String getSpec() {
            return this.spec;
        }

        @Deprecated
        public void setSpec(String spec) {
            this.spec = spec;
        }
    }

    public static class JCache {
        private Resource config;
        private String provider;

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public Resource getConfig() {
            return this.config;
        }

        public void setConfig(Resource config) {
            this.config = config;
        }
    }

    public static class Infinispan {
        private Resource config;

        public Resource getConfig() {
            return this.config;
        }

        public void setConfig(Resource config) {
            this.config = config;
        }
    }

    public static class Hazelcast {
        private Resource config;

        public Resource getConfig() {
            return this.config;
        }

        public void setConfig(Resource config) {
            this.config = config;
        }
    }

    public static class EhCache {
        private Resource config;

        public Resource getConfig() {
            return this.config;
        }

        public void setConfig(Resource config) {
            this.config = config;
        }
    }

    public static class Couchbase {
        private int expiration;

        public int getExpiration() {
            return this.expiration;
        }

        public int getExpirationSeconds() {
            return (int)TimeUnit.MILLISECONDS.toSeconds(this.expiration);
        }

        public void setExpiration(int expiration) {
            this.expiration = expiration;
        }
    }

    public static class Caffeine {
        private String spec;

        public String getSpec() {
            return this.spec;
        }

        public void setSpec(String spec) {
            this.spec = spec;
        }
    }
}

