/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.StatefulRetryOperationsInterceptor;
import org.springframework.retry.support.RetryTemplate;

public class StatefulRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    private static Log logger = LogFactory.getLog(StatefulRetryOperationsInterceptorFactoryBean.class);
    private MessageKeyGenerator messageKeyGenerator;
    private NewMessageIdentifier newMessageIdentifier;

    public void setMessageKeyGenerator(MessageKeyGenerator messageKeyGeneretor) {
        this.messageKeyGenerator = messageKeyGeneretor;
    }

    public void setNewMessageIdentifier(NewMessageIdentifier newMessageIdentifier) {
        this.newMessageIdentifier = newMessageIdentifier;
    }

    public StatefulRetryOperationsInterceptor getObject() {
        StatefulRetryOperationsInterceptor retryInterceptor = new StatefulRetryOperationsInterceptor();
        RetryOperations retryTemplate = this.getRetryOperations();
        if (retryTemplate == null) {
            retryTemplate = new RetryTemplate();
        }
        retryInterceptor.setRetryOperations(retryTemplate);
        retryInterceptor.setNewItemIdentifier(args -> {
            Message message = (Message)args[1];
            if (this.newMessageIdentifier == null) {
                return message.getMessageProperties().isRedelivered() == false;
            }
            return this.newMessageIdentifier.isNew(message);
        });
        MessageRecoverer messageRecoverer = this.getMessageRecoverer();
        retryInterceptor.setRecoverer((args, cause) -> {
            Message message = (Message)args[1];
            if (messageRecoverer == null) {
                logger.warn((Object)("Message dropped on recovery: " + message), cause);
            } else {
                messageRecoverer.recover(message, cause);
            }
            throw new ImmediateAcknowledgeAmqpException("Recovered message forces ack (if ack mode requires it): " + message, cause);
        });
        retryInterceptor.setKeyGenerator(args -> {
            Message message = (Message)args[1];
            if (this.messageKeyGenerator == null) {
                String messageId = message.getMessageProperties().getMessageId();
                if (messageId == null && message.getMessageProperties().isRedelivered().booleanValue()) {
                    message.getMessageProperties().setFinalRetryForMessageWithNoId(true);
                }
                return messageId;
            }
            return this.messageKeyGenerator.getKey(message);
        });
        return retryInterceptor;
    }

    public Class<?> getObjectType() {
        return StatefulRetryOperationsInterceptor.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

