/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.util.Assert;

public abstract class RabbitUtils {
    public static final int DEFAULT_PORT = 5672;
    private static final Log logger = LogFactory.getLog(RabbitUtils.class);
    private static final ThreadLocal<Boolean> physicalCloseRequired = new ThreadLocal();

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (Exception ex) {
                logger.debug((Object)("Ignoring Connection exception - assuming already closed: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void closeChannel(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (IOException ex) {
                logger.debug((Object)"Could not close RabbitMQ Channel", (Throwable)ex);
            }
            catch (ShutdownSignalException sig) {
                if (!RabbitUtils.isNormalShutdown(sig)) {
                    logger.debug((Object)"Unexpected exception on closing RabbitMQ Channel", (Throwable)sig);
                }
            }
            catch (Exception ex) {
                logger.debug((Object)"Unexpected exception on closing RabbitMQ Channel", (Throwable)ex);
            }
        }
    }

    public static void commitIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txCommit();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static void rollbackIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txRollback();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static void closeMessageConsumer(Channel channel, Collection<String> consumerTags, boolean transactional) {
        if (!channel.isOpen()) {
            return;
        }
        try {
            for (String consumerTag : consumerTags) {
                channel.basicCancel(consumerTag);
            }
            if (transactional) {
                channel.basicRecover(true);
            }
        }
        catch (Exception ex) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex);
        }
    }

    public static void declareTransactional(Channel channel) {
        try {
            channel.txSelect();
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    public static void setPhysicalCloseRequired(boolean b) {
        physicalCloseRequired.set(b);
    }

    public static boolean isPhysicalCloseRequired() {
        Boolean mustClose = physicalCloseRequired.get();
        if (mustClose == null) {
            mustClose = Boolean.FALSE;
        } else {
            physicalCloseRequired.remove();
        }
        return mustClose;
    }

    public static boolean isNormalShutdown(ShutdownSignalException sig) {
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Connection.Close && 200 == ((AMQP.Connection.Close)shutdownReason).getReplyCode() && "OK".equals(((AMQP.Connection.Close)shutdownReason).getReplyText());
    }

    public static boolean isNormalChannelClose(ShutdownSignalException sig) {
        Method shutdownReason = sig.getReason();
        return RabbitUtils.isNormalShutdown(sig) || shutdownReason instanceof AMQP.Channel.Close && 200 == ((AMQP.Channel.Close)shutdownReason).getReplyCode() && "OK".equals(((AMQP.Channel.Close)shutdownReason).getReplyText());
    }

    public static boolean isPassiveDeclarationChannelClose(ShutdownSignalException sig) {
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Channel.Close && 404 == ((AMQP.Channel.Close)shutdownReason).getReplyCode() && (((AMQP.Channel.Close)shutdownReason).getClassId() == 40 || ((AMQP.Channel.Close)shutdownReason).getClassId() == 50) && ((AMQP.Channel.Close)shutdownReason).getMethodId() == 10;
    }

    public static boolean isExclusiveUseChannelClose(ShutdownSignalException sig) {
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Channel.Close && 403 == ((AMQP.Channel.Close)shutdownReason).getReplyCode() && ((AMQP.Channel.Close)shutdownReason).getClassId() == 60 && ((AMQP.Channel.Close)shutdownReason).getMethodId() == 20 && ((AMQP.Channel.Close)shutdownReason).getReplyText().contains("exclusive");
    }

    public static boolean isMismatchedQueueArgs(Exception e) {
        ShutdownSignalException sig = null;
        for (Throwable cause = e; cause != null && sig == null; cause = cause.getCause()) {
            if (!(cause instanceof ShutdownSignalException)) continue;
            sig = (ShutdownSignalException)cause;
        }
        if (sig == null) {
            return false;
        }
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Channel.Close && 406 == ((AMQP.Channel.Close)shutdownReason).getReplyCode() && ((AMQP.Channel.Close)shutdownReason).getClassId() == 50 && ((AMQP.Channel.Close)shutdownReason).getMethodId() == 10;
    }

    public static boolean isExchangeDeclarationFailure(Exception e) {
        ShutdownSignalException sig = null;
        for (Throwable cause = e; cause != null && sig == null; cause = cause.getCause()) {
            if (!(cause instanceof ShutdownSignalException)) continue;
            sig = (ShutdownSignalException)cause;
        }
        if (sig == null) {
            return false;
        }
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Connection.Close && 503 == ((AMQP.Connection.Close)shutdownReason).getReplyCode() && ((AMQP.Connection.Close)shutdownReason).getClassId() == 40 && ((AMQP.Connection.Close)shutdownReason).getMethodId() == 10;
    }
}

