/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.annotation.spring.scan;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

class AnnotatedMethodDiscovery {
    protected final Set<Class<? extends Annotation>> targetAnnotations;

    AnnotatedMethodDiscovery(Set<Class<? extends Annotation>> targetAnnotations) {
        this.targetAnnotations = targetAnnotations;
    }

    protected Set<Class<? extends Annotation>> scan(Class<?> beanClass) {
        HashSet<Class<? extends Annotation>> foundAnnotations = new HashSet<Class<? extends Annotation>>();
        ReflectionUtils.doWithMethods(beanClass, method -> this.targetAnnotations.forEach(annotationType -> {
            if (AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null) {
                foundAnnotations.add((Class<? extends Annotation>)annotationType);
            }
        }));
        return foundAnnotations;
    }
}

