/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.chat.observation.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.observation.ChatModelCompletionObservationFilter;
import org.springframework.ai.chat.observation.ChatModelCompletionObservationHandler;
import org.springframework.ai.chat.observation.ChatModelMeterObservationHandler;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelPromptContentObservationFilter;
import org.springframework.ai.chat.observation.ChatModelPromptContentObservationHandler;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.ai.model.chat.observation.autoconfigure.ChatObservationProperties;
import org.springframework.ai.model.observation.ErrorLoggingObservationHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(afterName={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@ConditionalOnClass(value={ChatModel.class})
@EnableConfigurationProperties(value={ChatObservationProperties.class})
public class ChatObservationAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ChatObservationAutoConfiguration.class);

    private static void logPromptContentWarning() {
        logger.warn("You have enabled the inclusion of the prompt content in the observations, with the risk of exposing sensitive or private information. Please, be careful!");
    }

    private static void logCompletionWarning() {
        logger.warn("You have enabled the inclusion of the completion content in the observations, with the risk of exposing sensitive or private information. Please, be careful!");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MeterRegistry.class})
    ChatModelMeterObservationHandler chatModelMeterObservationHandler(ObjectProvider<MeterRegistry> meterRegistry) {
        return new ChatModelMeterObservationHandler((MeterRegistry)meterRegistry.getObject());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    @ConditionalOnBean(value={Tracer.class})
    static class TracingChatContentObservationConfiguration {
        TracingChatContentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.chat.observations", name={"include-error-logging"}, havingValue="true")
        public ErrorLoggingObservationHandler errorLoggingObservationHandler(Tracer tracer) {
            return new ErrorLoggingObservationHandler(tracer, List.of(EmbeddingModelObservationContext.class, ImageModelObservationContext.class, ChatModelObservationContext.class, ChatClientObservationContext.class, AdvisorObservationContext.class));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.tracing.otel.bridge.OtelTracer"})
    static class FallbackChatContentObservationConfiguration {
        FallbackChatContentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.chat.observations", name={"include-prompt"}, havingValue="true")
        ChatModelPromptContentObservationFilter chatModelPromptObservationFilter() {
            ChatObservationAutoConfiguration.logPromptContentWarning();
            return new ChatModelPromptContentObservationFilter();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.chat.observations", name={"include-completion"}, havingValue="true")
        ChatModelCompletionObservationFilter chatModelCompletionObservationFilter() {
            ChatObservationAutoConfiguration.logCompletionWarning();
            return new ChatModelCompletionObservationFilter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OtelTracer.class})
    @ConditionalOnBean(value={OtelTracer.class})
    static class PrimaryChatContentObservationConfiguration {
        PrimaryChatContentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.chat.observations", name={"include-prompt"}, havingValue="true")
        ChatModelPromptContentObservationHandler chatModelPromptContentObservationHandler() {
            ChatObservationAutoConfiguration.logPromptContentWarning();
            return new ChatModelPromptContentObservationHandler();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.chat.observations", name={"include-completion"}, havingValue="true")
        ChatModelCompletionObservationHandler chatModelCompletionObservationHandler() {
            ChatObservationAutoConfiguration.logCompletionWarning();
            return new ChatModelCompletionObservationHandler();
        }
    }
}

