/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class WorkSet<T> {
    private final Set<T> elements;

    public WorkSet() {
        this.elements = new LinkedHashSet<T>();
    }

    public WorkSet(Collection<T> initialElements) {
        this.elements = new LinkedHashSet<T>(initialElements);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public T pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot pop from an empty WorkSet");
        }
        T element = this.elements.iterator().next();
        this.elements.remove(element);
        return element;
    }

    public void add(T element) {
        this.elements.add(element);
    }

    public void addAll(Collection<T> newElements) {
        this.elements.addAll(newElements);
    }
}

