/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.sonar.ucfg.BasicBlock;
import org.sonar.ucfg.Expression;
import org.sonar.ucfg.Instruction;
import org.sonar.ucfg.Label;
import org.sonar.ucfg.LocationInFile;
import org.sonar.ucfg.UCFG;

public final class UCFGtoJson {
    private UCFGtoJson() {
    }

    public static String toJson(UCFG ucfg) {
        GsonBuilder gson = new GsonBuilder().setPrettyPrinting();
        gson.registerTypeAdapter(UCFG.class, (Object)new UcfgSerializer());
        gson.registerTypeAdapter(Label.class, (Object)new LabelSerializer());
        gson.registerTypeAdapter(Expression.Variable.class, (Object)new VariableSerializer());
        gson.registerTypeAdapter(Expression.Constant.class, (Object)new ConstantSerializer());
        gson.registerTypeAdapter(BasicBlock.class, (Object)new BasicBlockSerializer());
        gson.registerTypeAdapter(Instruction.AssignCall.class, (Object)new AssignCallSerializer());
        gson.registerTypeAdapter(Instruction.Ret.class, (Object)new ReturnSerializer());
        gson.registerTypeAdapter(Instruction.Jump.class, (Object)new JumpSerializer());
        gson.registerTypeAdapter(LocationInFile.class, (Object)new LocationSerializer());
        return gson.create().toJson((Object)ucfg);
    }

    private static class JumpSerializer
    implements JsonSerializer<Instruction.Jump> {
        private JumpSerializer() {
        }

        public JsonElement serialize(Instruction.Jump src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", "Jump");
            jsonObject.add("jumpDest", context.serialize(src.destinations()));
            return jsonObject;
        }
    }

    private static class ReturnSerializer
    implements JsonSerializer<Instruction.Ret> {
        private ReturnSerializer() {
        }

        public JsonElement serialize(Instruction.Ret src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", "Ret");
            jsonObject.add("retLoc", context.serialize((Object)src.location()));
            jsonObject.add("retExpr", context.serialize((Object)src.getReturnedExpression()));
            return jsonObject;
        }
    }

    private static class LocationSerializer
    implements JsonSerializer<LocationInFile> {
        private LocationSerializer() {
        }

        public JsonElement serialize(LocationInFile src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("locFileId", src.getFileId());
            jsonObject.addProperty("locStartLine", (Number)src.getStartLine());
            jsonObject.addProperty("locStartLineOffset", (Number)src.getStartLineOffset());
            jsonObject.addProperty("locEndLine", (Number)src.getEndLine());
            jsonObject.addProperty("locEndLineOffset", (Number)src.getEndLineOffset());
            return jsonObject;
        }
    }

    private static class AssignCallSerializer
    implements JsonSerializer<Instruction.AssignCall> {
        private AssignCallSerializer() {
        }

        public JsonElement serialize(Instruction.AssignCall src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("instrLoc", context.serialize((Object)src.location()));
            jsonObject.addProperty("instrLhs", src.getLhs().id());
            jsonObject.add("instrMeth", context.serialize((Object)src.getMethodId()));
            jsonObject.add("instrArgs", context.serialize(src.getArgExpressions()));
            return jsonObject;
        }
    }

    private static class BasicBlockSerializer
    implements JsonSerializer<BasicBlock> {
        private BasicBlockSerializer() {
        }

        public JsonElement serialize(BasicBlock src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("bbId", context.serialize((Object)src.label()));
            jsonObject.add("bbLoc", context.serialize((Object)src.locationInFile()));
            jsonObject.add("bbInstr", context.serialize(src.calls()));
            jsonObject.add("bbTerm", context.serialize((Object)src.terminator()));
            return jsonObject;
        }
    }

    private static class ConstantSerializer
    implements JsonSerializer<Expression.Constant> {
        private ConstantSerializer() {
        }

        public JsonElement serialize(Expression.Constant src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", "Const");
            jsonObject.addProperty("constValue", src.toString());
            return jsonObject;
        }
    }

    private static class VariableSerializer
    implements JsonSerializer<Expression.Variable> {
        private VariableSerializer() {
        }

        public JsonElement serialize(Expression.Variable src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", "Var");
            jsonObject.addProperty("varName", src.id());
            return jsonObject;
        }
    }

    private static class LabelSerializer
    implements JsonSerializer<Label> {
        private LabelSerializer() {
        }

        public JsonElement serialize(Label src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id());
        }
    }

    private static class UcfgSerializer
    implements JsonSerializer<UCFG> {
        private UcfgSerializer() {
        }

        public JsonElement serialize(UCFG ucfg, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("ucfgId", ucfg.methodId());
            jsonObject.add("ucfgLoc", jsonSerializationContext.serialize((Object)ucfg.location()));
            jsonObject.add("ucfgParams", jsonSerializationContext.serialize(ucfg.parameters().stream().map(Expression.Variable::id).collect(Collectors.toList())));
            jsonObject.add("ucfgEntries", jsonSerializationContext.serialize(ucfg.entryBlocks().stream().map(BasicBlock::label).collect(Collectors.toSet())));
            jsonObject.add("ucfgBody", jsonSerializationContext.serialize(ucfg.basicBlocks().values()));
            return jsonObject;
        }
    }
}

