/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg;

import java.util.stream.Collectors;
import org.sonar.ucfg.BasicBlock;
import org.sonar.ucfg.UCFG;

public class UCFGPrinter {
    private final UCFG ucfg;

    public UCFGPrinter(UCFG ucfg) {
        this.ucfg = ucfg;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Signature: ");
        sb.append(this.ucfg.methodId());
        sb.append('\n');
        sb.append("Parameters:\n");
        for (int i = 0; i < this.ucfg.parameters().size(); ++i) {
            sb.append("  #");
            sb.append(i);
            sb.append(" -> ");
            sb.append(this.ucfg.parameters().get(i));
            sb.append('\n');
        }
        sb.append("Instructions:\n");
        sb.append(this.ucfg.basicBlocks().values().stream().map(BasicBlock::toString).collect(Collectors.joining("\n")));
        return sb.toString();
    }
}

