/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.ucfg.BasicBlock;
import org.sonar.ucfg.Expression;
import org.sonar.ucfg.Instruction;
import org.sonar.ucfg.Label;
import org.sonar.ucfg.LocationInFile;
import org.sonar.ucfg.UCFG;
import org.sonar.ucfg.util.WorkSet;

public class UCFGBuilder {
    public static final LocationInFile LOC = new LocationInFile("__unknown_file", 1, 1, 1, 1);
    private final List<BasicBlock> blocks = new ArrayList<BasicBlock>();
    private final String methodId;
    private List<Expression.Variable> parameters;
    private Set<BasicBlock> startingBlocks = new HashSet<BasicBlock>();
    private LocationInFile location = LOC;

    private UCFGBuilder(String methodId) {
        this.methodId = methodId;
        this.parameters = new ArrayList<Expression.Variable>();
    }

    public List<BasicBlock> getBlocks() {
        return this.blocks;
    }

    public static BlockBuilder newBasicBlock(String labelId) {
        return UCFGBuilder.newBasicBlock(labelId, LOC);
    }

    public static BlockBuilder newBasicBlock(String labelId, @Nullable LocationInFile loc) {
        return new BlockBuilder(labelId, loc);
    }

    public UCFGBuilder at(LocationInFile location) {
        this.location = location;
        return this;
    }

    public UCFGBuilder addStartingBlock(BlockBuilder blockBuilder) {
        BasicBlock block = blockBuilder.build();
        this.startingBlocks.add(block);
        this.blocks.add(block);
        return this;
    }

    public UCFGBuilder addBasicBlock(BlockBuilder blockBuilder) {
        this.blocks.add(blockBuilder.build());
        return this;
    }

    public UCFG build() {
        if (this.blocks.isEmpty()) {
            this.addBasicBlock(UCFGBuilder.newBasicBlock("startLabel").ret(UCFGBuilder.constant("const")));
        }
        if (this.startingBlocks.isEmpty()) {
            this.startingBlocks.add(this.blocks.get(0));
        }
        return new UCFG(this.methodId, this.parameters, UCFGBuilder.removeUnreachable(this.blocks, this.startingBlocks), this.startingBlocks, this.location);
    }

    private static Set<BasicBlock> removeUnreachable(List<BasicBlock> blocks, Set<BasicBlock> startingBlocks) {
        HashSet<BasicBlock> reached = new HashSet<BasicBlock>();
        WorkSet<BasicBlock> workSet = new WorkSet<BasicBlock>(startingBlocks);
        Map blockByLabel = blocks.stream().collect(Collectors.toMap(BasicBlock::label, Function.identity()));
        while (!workSet.isEmpty()) {
            BasicBlock current = workSet.pop();
            if (!reached.add(current)) continue;
            current.successors().forEach(l -> workSet.add((BasicBlock)blockByLabel.get(l)));
        }
        return reached;
    }

    public static UCFGBuilder createUCFGForMethod(String methodId) {
        return new UCFGBuilder(methodId);
    }

    public static Label createLabel(String labelId) {
        return new Label(labelId);
    }

    public static CallBuilder call(String methodId) {
        return new CallBuilder(methodId);
    }

    public static Expression.Variable variableWithId(String id) {
        return new Expression.Variable(id);
    }

    public static Expression.Constant constant(String value) {
        return new Expression.Constant(value);
    }

    public UCFGBuilder addMethodParam(Expression.Variable parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public static class CallBuilder {
        private final String methodId;
        private List<Expression> arguments = new ArrayList<Expression>();

        private CallBuilder(String methodId) {
            this.methodId = methodId;
        }

        public CallBuilder withArgs(Expression ... args) {
            this.arguments = Arrays.asList(args);
            return this;
        }
    }

    public static class BlockBuilder {
        private Instruction.Terminator terminator;
        private List<Instruction.AssignCall> calls = new ArrayList<Instruction.AssignCall>();
        private final Label label;
        private final LocationInFile loc;

        BlockBuilder(String labelId, @Nullable LocationInFile loc) {
            this.label = new Label(labelId);
            this.loc = loc;
        }

        public BlockBuilder terminator(Instruction.Terminator terminator) {
            if (this.terminator != null) {
                throw new IllegalStateException("A terminator is already set for block " + this.label.id());
            }
            this.terminator = terminator;
            return this;
        }

        public BlockBuilder assignTo(Expression.Variable var, CallBuilder callBuilder) {
            return this.assignTo(var, callBuilder, LOC);
        }

        public BlockBuilder assignTo(Expression.Variable var, CallBuilder callBuilder, LocationInFile loc) {
            this.calls.add(new Instruction.AssignCall(loc, var, callBuilder.methodId, callBuilder.arguments));
            return this;
        }

        BasicBlock build() {
            if (this.terminator == null) {
                throw new IllegalStateException("A terminator should be set for block " + this.label.id());
            }
            return new BasicBlock(this.label, this.calls, this.terminator, this.loc);
        }

        public BlockBuilder ret(Expression expression) {
            return this.ret(expression, LOC);
        }

        public BlockBuilder ret(Expression expression, LocationInFile locationInFile) {
            return this.terminator(new Instruction.Ret(locationInFile, expression));
        }

        public BlockBuilder jumpTo(Label ... labels) {
            return this.terminator(new Instruction.Jump(Arrays.asList(labels)));
        }
    }
}

