/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.ucfg.BasicBlock;
import org.sonar.ucfg.Expression;
import org.sonar.ucfg.Label;
import org.sonar.ucfg.LocationInFile;
import org.sonar.ucfg.util.WorkSet;

public class UCFG {
    private final String methodId;
    private final List<Expression.Variable> parameters;
    private Map<Label, BasicBlock> basicBlocks;
    private Map<Label, BasicBlock> nonRedundantGraph;
    private Set<BasicBlock> nonRedundantEntryBlocks;
    private LocationInFile location;
    private boolean requiresDeadEnd = false;

    public UCFG(String methodId, List<Expression.Variable> parameters, Set<BasicBlock> basicBlocks, Set<BasicBlock> entryBlocks, LocationInFile location) {
        this.methodId = methodId;
        this.parameters = parameters;
        this.basicBlocks = basicBlocks.stream().collect(Collectors.toMap(BasicBlock::label, Function.identity()));
        this.location = location;
        this.computeFilteredGraph(entryBlocks);
    }

    public String methodId() {
        return this.methodId;
    }

    public List<Expression.Variable> parameters() {
        return this.parameters;
    }

    private void computeFilteredGraph(Set<BasicBlock> entryBlocks) {
        this.nonRedundantEntryBlocks = entryBlocks.stream().flatMap(bb -> {
            if (bb.isRedundant()) {
                return this.nonRedundantSuccessors((BasicBlock)bb).stream();
            }
            return Stream.of(bb);
        }).collect(Collectors.toSet());
        Map newSuccessors = this.basicBlocks.values().stream().filter(b -> !b.isRedundant()).collect(Collectors.toMap(Function.identity(), this::nonRedundantSuccessors));
        newSuccessors.forEach(BasicBlock::updateSuccs);
        this.nonRedundantGraph = newSuccessors.keySet().stream().collect(Collectors.toMap(BasicBlock::label, Function.identity()));
        if (this.requiresDeadEnd) {
            this.nonRedundantGraph.put(BasicBlock.DEAD_END.label(), BasicBlock.DEAD_END);
            this.basicBlocks.put(BasicBlock.DEAD_END.label(), BasicBlock.DEAD_END);
        }
        if (this.nonRedundantGraph.values().stream().anyMatch(BasicBlock::isRedundant)) {
            throw new IllegalStateException("Pruned graph should not contain any redundant blocks.");
        }
    }

    private Set<BasicBlock> nonRedundantSuccessors(BasicBlock basicBlock) {
        HashSet<BasicBlock> res = new HashSet<BasicBlock>();
        HashSet<BasicBlock> seen = new HashSet<BasicBlock>();
        WorkSet<BasicBlock> workSet = new WorkSet<BasicBlock>(this.successors(basicBlock));
        while (!workSet.isEmpty()) {
            BasicBlock succ = workSet.pop();
            if (!seen.add(succ)) continue;
            if (succ.isRedundant()) {
                workSet.addAll(this.successors(succ));
                continue;
            }
            res.add(succ);
        }
        if (!seen.isEmpty() && res.isEmpty()) {
            this.requiresDeadEnd = true;
            return Collections.singleton(BasicBlock.DEAD_END);
        }
        return res;
    }

    private Set<BasicBlock> successors(BasicBlock b) {
        return b.successors().stream().map(this.basicBlocks::get).collect(Collectors.toSet());
    }

    public Map<Label, BasicBlock> basicBlocks() {
        return this.nonRedundantGraph;
    }

    public Set<BasicBlock> entryBlocks() {
        return this.nonRedundantEntryBlocks;
    }

    public LocationInFile location() {
        return this.location;
    }
}

