/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.ucfg.Expression;
import org.sonar.ucfg.Label;
import org.sonar.ucfg.LocationInFile;

public abstract class Instruction {
    private final InstructionType type;
    final LocationInFile locationInFile;

    private Instruction(InstructionType type, @Nullable LocationInFile locationInFile) {
        this.type = type;
        this.locationInFile = locationInFile;
    }

    public InstructionType type() {
        return this.type;
    }

    public LocationInFile location() {
        return this.locationInFile;
    }

    public static class Jump
    extends Terminator {
        private final List<Label> destinations;

        public Jump(List<Label> destinations) {
            super(InstructionType.JUMP, null);
            if (destinations.isEmpty()) {
                throw new IllegalStateException("Cannot create jump with empty destinations");
            }
            this.destinations = destinations;
        }

        public String toString() {
            return "    jump " + this.destinations.stream().map(Label::id).collect(Collectors.joining(", "));
        }

        public List<Label> destinations() {
            return this.destinations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Jump jump = (Jump)o;
            return Objects.equals(this.destinations, jump.destinations);
        }

        public int hashCode() {
            return Objects.hash(this.destinations);
        }
    }

    public static class Ret
    extends Terminator {
        private final Expression returnedExpression;

        public Ret(LocationInFile locationInFile, Expression returnedExpression) {
            super(InstructionType.RET, locationInFile);
            this.returnedExpression = returnedExpression;
        }

        public String toString() {
            return "     ret " + this.returnedExpression + this.locationInFile.toString();
        }

        public Expression getReturnedExpression() {
            return this.returnedExpression;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ret ret = (Ret)o;
            return Objects.equals(this.returnedExpression, ret.returnedExpression) && Objects.equals(this.locationInFile, ret.locationInFile);
        }

        public int hashCode() {
            return Objects.hash(this.returnedExpression, this.locationInFile);
        }
    }

    public static class AssignCall
    extends Instruction {
        private final Expression.Variable lhs;
        private final String methodId;
        private final List<Expression> argExpressions;

        public AssignCall(LocationInFile locationInFile, Expression.Variable lhs, String methodId, List<Expression> argExpressions) {
            super(InstructionType.CALL, locationInFile);
            this.lhs = lhs;
            this.methodId = methodId;
            this.argExpressions = argExpressions;
        }

        public String getMethodId() {
            return this.methodId;
        }

        public List<Expression> getArgExpressions() {
            return this.argExpressions;
        }

        public String toString() {
            return "    call " + this.lhs + " = " + this.methodId + " (" + this.argExpressions.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")" + this.locationInFile.toString();
        }

        public Expression.Variable getLhs() {
            return this.lhs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssignCall that = (AssignCall)o;
            return Objects.equals(this.lhs, that.lhs) && Objects.equals(this.methodId, that.methodId) && Objects.equals(this.argExpressions, that.argExpressions) && Objects.equals(this.locationInFile, that.locationInFile);
        }

        public int hashCode() {
            return Objects.hash(this.lhs, this.methodId, this.argExpressions, this.locationInFile);
        }
    }

    public static abstract class Terminator
    extends Instruction {
        private Terminator(InstructionType type, @Nullable LocationInFile locationInFile) {
            super(type, locationInFile);
        }
    }

    public static enum InstructionType {
        CALL,
        RET,
        JUMP;

    }
}

