/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg;

import java.util.Objects;

public interface Expression {
    default public boolean isConstant() {
        return false;
    }

    public static class Constant
    implements Expression {
        private final String value;

        public Constant(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constant constant = (Constant)o;
            return Objects.equals(this.value, constant.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class Variable
    implements Expression {
        private final String id;

        public Variable(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return Objects.equals(this.id, variable.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

