/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ucfg;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.ucfg.Instruction;
import org.sonar.ucfg.Label;
import org.sonar.ucfg.LocationInFile;

public class BasicBlock {
    private final Label label;
    private final List<Instruction.AssignCall> calls;
    private final LocationInFile loc;
    private Instruction.Terminator terminator;
    private static final Label DEAD_END_LABEL = new Label("DEAD_END");
    public static final BasicBlock DEAD_END = new BasicBlock(DEAD_END_LABEL, Collections.emptyList(), (Instruction.Terminator)new Instruction.Jump(Collections.singletonList(DEAD_END_LABEL)), null){

        @Override
        public boolean isRedundant() {
            return false;
        }

        @Override
        public void updateSuccs(Set<BasicBlock> successors) {
        }
    };

    BasicBlock(Label label, List<Instruction.AssignCall> calls, Instruction.Terminator terminator, @Nullable LocationInFile loc) {
        this.label = label;
        this.calls = calls;
        this.terminator = terminator;
        this.loc = loc;
    }

    public Label label() {
        return this.label;
    }

    public List<Instruction.AssignCall> calls() {
        return this.calls;
    }

    public Instruction.Terminator terminator() {
        return this.terminator;
    }

    public boolean isRedundant() {
        return this.calls.isEmpty() && !this.successors().isEmpty();
    }

    public List<Label> successors() {
        if (this.terminator.type() == Instruction.InstructionType.JUMP) {
            return ((Instruction.Jump)this.terminator).destinations();
        }
        return Collections.emptyList();
    }

    public void updateSuccs(Set<BasicBlock> successors) {
        if (this.terminator.type() == Instruction.InstructionType.JUMP) {
            this.terminator = new Instruction.Jump(successors.stream().map(BasicBlock::label).collect(Collectors.toList()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicBlock that = (BasicBlock)o;
        return Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    public String toString() {
        return this.label + "\n" + this.calls.stream().map(Instruction.AssignCall::toString).collect(Collectors.joining("\n")) + "\n" + this.terminator.toString();
    }

    @Nullable
    public LocationInFile locationInFile() {
        return this.loc;
    }
}

