/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.resources.Resource;

public final class Qualifiers {
    public static final String VIEW = "VW";
    public static final String SUBVIEW = "SVW";
    @Deprecated
    public static final String LIBRARY = "LIB";
    public static final String PROJECT = "TRK";
    public static final String MODULE = "BRC";
    @Deprecated
    public static final String PACKAGE = "PAC";
    public static final String DIRECTORY = "DIR";
    public static final String FILE = "FIL";
    @Deprecated
    public static final String CLASS = "CLA";
    @Deprecated
    public static final String PARAGRAPH = "PAR";
    @Deprecated
    public static final String METHOD = "MET";
    @Deprecated
    public static final String FIELD = "FLD";
    public static final String UNIT_TEST_FILE = "UTS";

    private Qualifiers() {
    }

    public static boolean isView(Resource resource, boolean acceptSubViews) {
        boolean isView = StringUtils.equals(VIEW, resource.getQualifier());
        if (!isView && acceptSubViews) {
            isView = StringUtils.equals(SUBVIEW, resource.getQualifier());
        }
        return isView;
    }

    public static boolean isSubview(Resource resource) {
        return StringUtils.equals(SUBVIEW, resource.getScope());
    }

    public static boolean isProject(Resource resource, boolean acceptModules) {
        boolean isProject = StringUtils.equals(PROJECT, resource.getQualifier());
        if (!isProject && acceptModules) {
            isProject = StringUtils.equals(MODULE, resource.getQualifier());
        }
        return isProject;
    }

    public static boolean isModule(Resource resource) {
        return StringUtils.equals(MODULE, resource.getQualifier());
    }

    public static boolean isDirectory(Resource resource) {
        return StringUtils.equals(DIRECTORY, resource.getQualifier());
    }

    @Deprecated
    public static boolean isPackage(Resource resource) {
        return StringUtils.equals(PACKAGE, resource.getQualifier()) || Qualifiers.isDirectory(resource);
    }

    public static boolean isFile(Resource resource) {
        return StringUtils.equals(FILE, resource.getQualifier());
    }

    @Deprecated
    public static boolean isClass(Resource resource) {
        return StringUtils.equals(CLASS, resource.getQualifier()) || Qualifiers.isFile(resource);
    }

    public static boolean isMethod(Resource resource) {
        return StringUtils.equals(METHOD, resource.getQualifier());
    }

    public static boolean isParagraph(Resource resource) {
        return StringUtils.equals(PARAGRAPH, resource.getQualifier());
    }
}

