/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRule;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;

@Immutable
public class DefaultActiveRules
implements ActiveRules {
    private final Map<String, List<ActiveRule>> activeRulesByRepository = new HashMap<String, List<ActiveRule>>();
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndKey = new HashMap<String, Map<String, ActiveRule>>();
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndInternalKey = new HashMap<String, Map<String, ActiveRule>>();
    private final Map<String, List<ActiveRule>> activeRulesByLanguage = new HashMap<String, List<ActiveRule>>();

    public DefaultActiveRules(Collection<NewActiveRule> newActiveRules) {
        for (NewActiveRule newAR : newActiveRules) {
            DefaultActiveRule ar = new DefaultActiveRule(newAR);
            String repo = ar.ruleKey().repository();
            this.activeRulesByRepository.computeIfAbsent(repo, x -> new ArrayList()).add(ar);
            if (ar.language() != null) {
                this.activeRulesByLanguage.computeIfAbsent(ar.language(), x -> new ArrayList()).add(ar);
            }
            this.activeRulesByRepositoryAndKey.computeIfAbsent(repo, r -> new HashMap()).put(ar.ruleKey().rule(), ar);
            String internalKey = ar.internalKey();
            if (internalKey == null) continue;
            this.activeRulesByRepositoryAndInternalKey.computeIfAbsent(repo, r -> new HashMap()).put(internalKey, ar);
        }
    }

    public ActiveRule find(RuleKey ruleKey) {
        return (ActiveRule)this.activeRulesByRepositoryAndKey.getOrDefault(ruleKey.repository(), Collections.emptyMap()).get(ruleKey.rule());
    }

    public Collection<ActiveRule> findAll() {
        return this.activeRulesByRepository.entrySet().stream().flatMap(x -> ((List)x.getValue()).stream()).collect(Collectors.toList());
    }

    public Collection<ActiveRule> findByRepository(String repository) {
        return this.activeRulesByRepository.getOrDefault(repository, Collections.emptyList());
    }

    public Collection<ActiveRule> findByLanguage(String language) {
        return this.activeRulesByLanguage.getOrDefault(language, Collections.emptyList());
    }

    public ActiveRule findByInternalKey(String repository, String internalKey) {
        return this.activeRulesByRepositoryAndInternalKey.containsKey(repository) ? this.activeRulesByRepositoryAndInternalKey.get(repository).get(internalKey) : null;
    }
}

