/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.Optional;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.CompilerArguments$;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.Locate$;
import sbt.internal.inc.MixedAnalyzingCompiler;
import sbt.internal.inc.PlainVirtualFile$;
import sbt.internal.inc.VirtualFileUtil$;
import sbt.internal.inc.caching.ClasspathCache$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.io.IO$;
import sbt.util.InterfaceUtil$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import xsbti.FileConverter;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileProgress;
import xsbti.compile.ExternalHooks;
import xsbti.compile.FileHash;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.JavaCompiler;
import xsbti.compile.MiniOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.analysis.ReadStamps;

public final class MixedAnalyzingCompiler$ {
    public static final MixedAnalyzingCompiler$ MODULE$ = new MixedAnalyzingCompiler$();
    private static final HashMap<Path, Reference<AnalysisStore>> cache = new HashMap();

    public boolean javaOnly(VirtualFileRef f) {
        return f.id().endsWith(".java");
    }

    public CompileConfiguration makeConfig(ScalaCompiler scalac, JavaCompiler javac, Seq<VirtualFile> sources, FileConverter converter, Seq<VirtualFile> classpath, GlobalsCache cache, Option<CompileProgress> progress, Seq<String> options, Seq<String> javacOptions, CompileAnalysis previousAnalysis, Option<MiniSetup> previousSetup, PerClasspathEntryLookup perClasspathEntryLookup, Reporter reporter, CompileOrder compileOrder, boolean skip, IncOptions incrementalCompilerOptions, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<AnalysisStore> earlyAnalysisStore, ReadStamps stamper, List<Tuple2<String, String>> extra) {
        Optional computed;
        Optional lookup = incrementalCompilerOptions.externalHooks().getExternalLookup();
        FileHash[] classpathHash = lookup.isPresent() ? ((computed = ((ExternalHooks.Lookup)lookup.get()).hashClasspath((VirtualFile[])classpath.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)))).isPresent() ? (FileHash[])computed.get() : MixedAnalyzingCompiler$.doHash$1(classpath, converter)) : MixedAnalyzingCompiler$.doHash$1(classpath, converter);
        MiniSetup compileSetup = MiniSetup.of((Output)output, (MiniOptions)MiniOptions.of((FileHash[])classpathHash, (String[])((String[])options.toArray(ClassTag$.MODULE$.apply(String.class))), (String[])((String[])javacOptions.toArray(ClassTag$.MODULE$.apply(String.class)))), (String)scalac.scalaInstance().actualVersion(), (CompileOrder)compileOrder, (boolean)incrementalCompilerOptions.storeApis(), (T2[])((T2[])extra.map((Function1 & Serializable)x -> InterfaceUtil$.MODULE$.t2(x)).toArray(ClassTag$.MODULE$.apply(T2.class))));
        return this.config(sources, converter, classpath, compileSetup, progress, previousAnalysis, previousSetup, perClasspathEntryLookup, scalac, javac, reporter, skip, cache, incrementalCompilerOptions, outputJarContent, earlyOutput, earlyAnalysisStore, stamper);
    }

    public Option<CompileProgress> makeConfig$default$7() {
        return None$.MODULE$;
    }

    public Seq<String> makeConfig$default$8() {
        return package$.MODULE$.Nil();
    }

    public Seq<String> makeConfig$default$9() {
        return package$.MODULE$.Nil();
    }

    public CompileOrder makeConfig$default$14() {
        return CompileOrder.Mixed;
    }

    public boolean makeConfig$default$15() {
        return false;
    }

    public CompileConfiguration config(Seq<VirtualFile> sources, FileConverter converter, Seq<VirtualFile> classpath, MiniSetup setup, Option<CompileProgress> progress, CompileAnalysis previousAnalysis, Option<MiniSetup> previousSetup, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler compiler, JavaCompiler javac, Reporter reporter, boolean skip, GlobalsCache cache, IncOptions incrementalCompilerOptions, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<AnalysisStore> earlyAnalysisStore, ReadStamps stamper) {
        return new CompileConfiguration(sources, converter, classpath, previousAnalysis, previousSetup, setup, progress, perClasspathEntryLookup, reporter, compiler, javac, cache, incrementalCompilerOptions, outputJarContent, earlyOutput, earlyAnalysisStore, stamper);
    }

    public Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(CompileConfiguration config) {
        return this.searchClasspathAndLookup(config.converter(), config.classpath(), config.currentSetup().options().scalacOptions(), config.perClasspathEntryLookup(), config.compiler());
    }

    public Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(FileConverter converter, Seq<VirtualFile> classpath, String[] scalacOptions, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler compiler) {
        Seq absClasspath = (Seq)classpath.map((Function1 & Serializable)x$6 -> VirtualFileUtil$.MODULE$.toAbsolute(x$6));
        CompilerArguments cArgs = new CompilerArguments(compiler.scalaInstance(), compiler.classpathOptions());
        Seq searchClasspath = (Seq)this.explicitBootClasspath((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)scalacOptions), converter).$plus$plus(this.withBootclasspath(cArgs, (Seq<VirtualFile>)absClasspath, converter));
        return new Tuple2((Object)searchClasspath, (Object)Locate$.MODULE$.entry(searchClasspath, perClasspathEntryLookup));
    }

    public Function1<String, Option<VirtualFile>> classPathLookup(CompileConfiguration config) {
        return (Function1)this.searchClasspathAndLookup(config)._2();
    }

    public MixedAnalyzingCompiler apply(CompileConfiguration config, Logger log) {
        Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> tuple2 = this.searchClasspathAndLookup(config);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq searchClasspath = (Seq)tuple2._1();
        Function1 entry = (Function1)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)searchClasspath, (Object)entry);
        Tuple2 tuple23 = tuple22;
        Seq searchClasspath2 = (Seq)tuple23._1();
        Function1 entry2 = (Function1)tuple23._2();
        return new MixedAnalyzingCompiler(config.compiler(), new AnalyzingJavaCompiler(config.javac(), config.classpath(), config.compiler().scalaInstance(), config.compiler().classpathOptions(), (Function1<String, Option<VirtualFile>>)entry2, (Seq<VirtualFile>)searchClasspath2), config, log, config.outputJarContent());
    }

    public Seq<VirtualFile> withBootclasspath(CompilerArguments args, Seq<VirtualFile> classpath, FileConverter converter) {
        Seq cp = (Seq)classpath.map((Function1 & Serializable)x$1 -> converter.toPath(x$1));
        return (Seq)((IterableOps)((IterableOps)args.bootClasspathFor(cp).map((Function1 & Serializable)x$8 -> converter.toVirtualFile(x$8))).$plus$plus((IterableOnce)args.extClasspath().map((Function1 & Serializable)x$9 -> PlainVirtualFile$.MODULE$.apply(x$9)))).$plus$plus((IterableOnce)args.finishClasspath(cp).map((Function1 & Serializable)x$10 -> converter.toVirtualFile(x$10)));
    }

    private Seq<VirtualFile> explicitBootClasspath(Seq<String> options, FileConverter converter) {
        return ((IterableOps)((IterableOps)options.dropWhile((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MixedAnalyzingCompiler$.$anonfun$explicitBootClasspath$1(x$11)))).slice(1, 2)).headOption().toList().flatMap((Function1 & Serializable)s -> IO$.MODULE$.parseClasspath(s)).map((Function1 & Serializable)x$12 -> x$12.toPath()).map((Function1 & Serializable)x$13 -> converter.toVirtualFile(x$13));
    }

    private synchronized AnalysisStore staticCache(Path file, Function0<AnalysisStore> backing) {
        return (AnalysisStore)cache.get((Object)file).flatMap((Function1 & Serializable)ref -> Option$.MODULE$.apply(ref.get())).getOrElse((Function0 & Serializable)() -> {
            void var2_2;
            AnalysisStore b = (AnalysisStore)backing.apply();
            cache.put((Object)file, new SoftReference<AnalysisStore>(b));
            return var2_2;
        });
    }

    public AnalysisStore staticCachedStore(Path analysisFile, boolean useTextAnalysis) {
        AnalysisStore fileStore = useTextAnalysis ? FileAnalysisStore$.MODULE$.text(analysisFile.toFile()) : FileAnalysisStore$.MODULE$.binary(analysisFile.toFile());
        AnalysisStore cachedStore = AnalysisStore.getCachedStore((AnalysisStore)fileStore);
        return this.staticCache(analysisFile, (Function0<AnalysisStore>)(Function0 & Serializable)() -> AnalysisStore.getThreadSafeStore((AnalysisStore)cachedStore));
    }

    private static final FileHash[] doHash$1(Seq classpath$1, FileConverter converter$1) {
        return ClasspathCache$.MODULE$.hashClasspath((Seq<Path>)((Seq)classpath$1.map((Function1 & Serializable)x$1 -> converter$1.toPath(x$1))));
    }

    public static final /* synthetic */ boolean $anonfun$explicitBootClasspath$1(String x$11) {
        String string = x$11;
        String string2 = CompilerArguments$.MODULE$.BootClasspathOption();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private MixedAnalyzingCompiler$() {
    }
}

