/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.revapi.CoIterator;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.Util;

public final class InheritanceChainChanged
extends CheckBase {
    private static final TypeVisitor<Boolean, Void> IS_MISSING_VISITOR = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitError(ErrorType t, Void __) {
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void aVoid) {
            return t.asElement().asType().getKind() == TypeKind.ERROR;
        }
    };
    private static final ElementVisitor<Boolean, Void> IS_THROWABLE_ELEMENT = new SimpleElementVisitor8<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitType(TypeElement e, Void aVoid) {
            return e.getQualifiedName().contentEquals("java.lang.Throwable");
        }
    };
    private static final TypeVisitor<Boolean, Void> IS_THROWABLE = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitDeclared(DeclaredType t, Void aVoid) {
            return (Boolean)t.asElement().accept(IS_THROWABLE_ELEMENT, null);
        }
    };

    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types != null) {
            String str;
            ArrayList<Difference> ret = new ArrayList<Difference>();
            List oldSuperClasses = (List)types.context[0];
            List newSuperClasses = (List)types.context[1];
            this.reportMissingSuperTypes(ret, oldSuperClasses, Code.MISSING_OLD_SUPERTYPE, types);
            this.reportMissingSuperTypes(ret, newSuperClasses, Code.MISSING_NEW_SUPERTYPE, types);
            if (!ret.isEmpty()) {
                return ret;
            }
            Comparator<TypeMirror> typeNameComparator = Comparator.comparing(Util::toUniqueString);
            List<TypeMirror> removedSuperClasses = new ArrayList<TypeMirror>();
            List<TypeMirror> addedSuperClasses = new ArrayList<TypeMirror>();
            oldSuperClasses.sort(typeNameComparator);
            newSuperClasses.sort(typeNameComparator);
            CoIterator iterator = new CoIterator(oldSuperClasses.iterator(), newSuperClasses.iterator(), typeNameComparator);
            while (iterator.hasNext()) {
                iterator.next();
                TypeMirror oldType = (TypeMirror)iterator.getLeft();
                TypeMirror newType = (TypeMirror)iterator.getRight();
                if (oldType == null) {
                    addedSuperClasses.add(newType);
                    continue;
                }
                if (newType != null) continue;
                removedSuperClasses.add(oldType);
            }
            removedSuperClasses = this.retainInCopy(oldSuperClasses, removedSuperClasses);
            addedSuperClasses = this.retainInCopy(newSuperClasses, addedSuperClasses);
            Iterator<TypeMirror> removedIt = removedSuperClasses.iterator();
            Iterator<TypeMirror> addedIt = addedSuperClasses.iterator();
            if (removedIt.hasNext()) {
                removedIt.next();
            }
            if (addedIt.hasNext()) {
                addedIt.next();
            }
            this.removeClassesWithEquivalentSuperClassChain(removedIt, this.getOldTypeEnvironment(), this.getNewTypeEnvironment());
            this.removeClassesWithEquivalentSuperClassChain(addedIt, this.getNewTypeEnvironment(), this.getOldTypeEnvironment());
            for (TypeMirror t : removedSuperClasses) {
                str = Util.toHumanReadableString((AnnotatedConstruct)t);
                ret.add(this.createDifference(Code.CLASS_NO_LONGER_INHERITS_FROM_CLASS, Code.attachmentsFor((JavaElement)((JavaTypeElement)types.oldElement), (JavaElement)((JavaTypeElement)types.newElement), (String[])new String[]{"superClass", str})));
            }
            for (TypeMirror t : addedSuperClasses) {
                str = Util.toHumanReadableString((AnnotatedConstruct)t);
                Code code = ((JavaTypeElement)types.oldElement).getDeclaringElement().getModifiers().contains((Object)Modifier.FINAL) ? Code.CLASS_FINAL_CLASS_INHERITS_FROM_NEW_CLASS : Code.CLASS_NON_FINAL_CLASS_INHERITS_FROM_NEW_CLASS;
                ret.add(this.createDifference(code, Code.attachmentsFor((JavaElement)((JavaTypeElement)types.oldElement), (JavaElement)((JavaTypeElement)types.newElement), (String[])new String[]{"superClass", str})));
            }
            if (this.containsThrowable(oldSuperClasses) && this.containsThrowable(newSuperClasses)) {
                boolean oldUnchecked = this.isUncheckedThrowable(oldSuperClasses);
                boolean newUnchecked = this.isUncheckedThrowable(newSuperClasses);
                if (oldUnchecked && !newUnchecked) {
                    ret.add(this.createDifference(Code.CLASS_NOW_CHECKED_EXCEPTION, Code.attachmentsFor((JavaElement)((JavaTypeElement)types.oldElement), (JavaElement)((JavaTypeElement)types.newElement), (String[])new String[0])));
                }
            }
            return ret;
        }
        return null;
    }

    protected void doVisitClass(JavaTypeElement oldEl, JavaTypeElement newEl) {
        if (!this.isBothAccessible((JavaModelElement)oldEl, (JavaModelElement)newEl)) {
            return;
        }
        TypeElement oldType = oldEl.getDeclaringElement();
        TypeElement newType = newEl.getDeclaringElement();
        List oldSuperTypes = Util.getAllSuperClasses((Types)this.getOldTypeEnvironment().getTypeUtils(), (TypeMirror)oldType.asType());
        List newSuperTypes = Util.getAllSuperClasses((Types)this.getNewTypeEnvironment().getTypeUtils(), (TypeMirror)newType.asType());
        if (oldSuperTypes.size() != newSuperTypes.size()) {
            this.pushActive((JavaElement)oldEl, (JavaElement)newEl, new Object[]{oldSuperTypes, newSuperTypes});
        } else {
            Types oldTypes = this.getOldTypeEnvironment().getTypeUtils();
            Types newTypes = this.getNewTypeEnvironment().getTypeUtils();
            for (int i = 0; i < oldSuperTypes.size(); ++i) {
                TypeMirror newSuperClass;
                TypeMirror oldSuperClass = oldTypes.erasure((TypeMirror)oldSuperTypes.get(i));
                if (Util.isSameType((TypeMirror)oldSuperClass, (TypeMirror)(newSuperClass = newTypes.erasure((TypeMirror)newSuperTypes.get(i))))) continue;
                this.pushActive((JavaElement)oldEl, (JavaElement)newEl, new Object[]{oldSuperTypes, newSuperTypes});
                break;
            }
        }
    }

    private boolean containsThrowable(List<TypeMirror> types) {
        for (TypeMirror t : types) {
            if (!IS_THROWABLE.visit(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isUncheckedThrowable(@Nonnull List<TypeMirror> superClassesOfType) {
        for (TypeMirror sc : superClassesOfType) {
            String typeName = Util.toHumanReadableString((AnnotatedConstruct)sc);
            if (!"java.lang.RuntimeException".equals(typeName) && !"java.lang.Error".equals(typeName)) continue;
            return true;
        }
        return false;
    }

    private List<String> superClassChainAsUniqueStrings(@Nonnull TypeMirror cls, @Nonnull Types env) {
        List supers = Util.getAllSuperClasses((Types)env, (TypeMirror)cls);
        ArrayList<String> ret = new ArrayList<String>(supers.size());
        for (TypeMirror s : supers) {
            ret.add(Util.toUniqueString((TypeMirror)env.erasure(s)));
        }
        return ret;
    }

    private void removeClassesWithEquivalentSuperClassChain(Iterator<TypeMirror> candidates, TypeEnvironment candidateEnvironment, TypeEnvironment oppositeEnvironment) {
        while (candidates.hasNext()) {
            boolean report = true;
            TypeMirror candidate = candidates.next();
            String typeName = Util.toHumanReadableString((AnnotatedConstruct)candidate);
            TypeElement el = oppositeEnvironment.getElementUtils().getTypeElement(typeName);
            if (el != null) {
                List<String> oppositeSuperChain;
                TypeMirror opposite = el.asType();
                List<String> candidateSuperChain = this.superClassChainAsUniqueStrings(candidate, candidateEnvironment.getTypeUtils());
                boolean bl = report = !candidateSuperChain.equals(oppositeSuperChain = this.superClassChainAsUniqueStrings(opposite, oppositeEnvironment.getTypeUtils()));
            }
            if (report) continue;
            candidates.remove();
        }
    }

    private List<TypeMirror> retainInCopy(List<TypeMirror> all, List<TypeMirror> retained) {
        ArrayList<TypeMirror> tmp = new ArrayList<TypeMirror>(all);
        tmp.retainAll(retained);
        return tmp;
    }

    private void reportMissingSuperTypes(List<Difference> diffs, List<TypeMirror> superTypes, Code code, CheckBase.ActiveElements<?> activeElements) {
        for (TypeMirror t : superTypes) {
            if (!InheritanceChainChanged.isMissing(t)) continue;
            String type = Util.toHumanReadableString((AnnotatedConstruct)t);
            diffs.add(this.createDifferenceWithExplicitParams(code, Code.attachmentsFor((JavaElement)activeElements.oldElement, (JavaElement)activeElements.newElement, (String[])new String[]{"superClass", type}), new String[]{type}));
        }
    }

    private static boolean isMissing(TypeMirror type) {
        return type.accept(IS_MISSING_VISITOR, null);
    }
}

