/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal;

class ParameterTypesMatcher {
    private boolean isVarArgs;
    private Class<?>[] expectedParameterTypes;
    private Class<?>[] actualParameterTypes;

    public ParameterTypesMatcher(boolean isVarArgs, Class<?>[] expectedParameterTypes, Class<?> ... actualParameterTypes) {
        this.isVarArgs = isVarArgs;
        this.expectedParameterTypes = expectedParameterTypes;
        this.actualParameterTypes = actualParameterTypes;
    }

    private boolean isRemainParamsVarArgs(int index, Class<?> actualParameterType) {
        return this.isVarArgs && index == this.expectedParameterTypes.length - 1 && actualParameterType.getComponentType().isAssignableFrom(this.expectedParameterTypes[index]);
    }

    private boolean isParameterTypesNotMatch(Class<?> actualParameterType, Class<?> expectedParameterType) {
        if (actualParameterType == null) {
            return false;
        }
        if (expectedParameterType == null) {
            return false;
        }
        return !actualParameterType.isAssignableFrom(expectedParameterType);
    }

    public boolean match() {
        this.assertParametersTypesNotNull();
        if (this.isParametersLengthMatch()) {
            return false;
        }
        return this.isParametersMatch();
    }

    private boolean isParametersLengthMatch() {
        return this.expectedParameterTypes.length != this.actualParameterTypes.length;
    }

    private void assertParametersTypesNotNull() {
        if (this.expectedParameterTypes == null || this.actualParameterTypes == null) {
            throw new IllegalArgumentException("parameter types cannot be null");
        }
    }

    private Boolean isParametersMatch() {
        for (int index = 0; index < this.expectedParameterTypes.length; ++index) {
            Class<?> actualParameterType = this.actualParameterTypes[index];
            if (this.isRemainParamsVarArgs(index, actualParameterType)) {
                return true;
            }
            Class<?> expectedParameterType = this.expectedParameterTypes[index];
            if (!this.isParameterTypesNotMatch(actualParameterType, expectedParameterType)) continue;
            return false;
        }
        return true;
    }
}

