/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.nat.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ops4j.pax.exam.ConfigurationManager;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.FrameworkEventUtils;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.FrameworkPropertyOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.ValueOption;
import org.ops4j.pax.exam.options.extra.CleanCachesOption;
import org.ops4j.pax.exam.options.extra.RepositoryOption;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeTestContainer
implements TestContainer {
    private static final Logger LOG = LoggerFactory.getLogger(NativeTestContainer.class);
    private static final String PROBE_SIGNATURE_KEY = "Probe-Signature";
    private final Stack<Long> installed = new Stack();
    private Long probeId;
    private final FrameworkFactory frameworkFactory;
    private ExamSystem system;
    private volatile Framework framework;

    public NativeTestContainer(ExamSystem system, FrameworkFactory frameworkFactory) throws IOException {
        this.frameworkFactory = frameworkFactory;
        this.system = system;
    }

    public synchronized void call(TestAddress address) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROBE_SIGNATURE_KEY, address.root().identifier());
        BundleContext bundleContext = this.framework.getBundleContext();
        ProbeInvoker probeInvokerService = (ProbeInvoker)ServiceLookup.getService((BundleContext)bundleContext, ProbeInvoker.class, (long)this.determineExamServiceTimeout(), props);
        probeInvokerService.call(address.arguments());
    }

    private long determineExamServiceTimeout() {
        String timeoutProp = System.getProperty("pax.exam.service.timeout", "10000");
        try {
            return Long.valueOf(timeoutProp);
        }
        catch (NumberFormatException exc) {
            LOG.warn("Invalid timeout value {}, falling back to default");
            return Long.valueOf("10000");
        }
    }

    public synchronized long install(String location, InputStream stream) {
        try {
            Bundle b = this.framework.getBundleContext().installBundle(location, stream);
            this.installed.push(b.getBundleId());
            LOG.debug("Installed bundle " + b.getSymbolicName() + " as Bundle ID " + b.getBundleId());
            this.setBundleStartLevel(b.getBundleId(), 5);
            b.start();
            return b.getBundleId();
        }
        catch (BundleException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public synchronized long install(InputStream stream) {
        return this.install("local", stream);
    }

    public synchronized void cleanup() {
        while (!this.installed.isEmpty()) {
            try {
                Long id = this.installed.pop();
                Bundle bundle = this.framework.getBundleContext().getBundle(id.longValue());
                bundle.uninstall();
                LOG.debug("Uninstalled bundle " + id);
            }
            catch (BundleException bundleException) {}
        }
    }

    public Bundle getSystemBundle() {
        return this.framework;
    }

    public void setBundleStartLevel(long bundleId, int startLevel) {
        Bundle bundle = this.framework.getBundleContext().getBundle(bundleId);
        BundleStartLevel sl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        sl.setStartLevel(startLevel);
    }

    public TestContainer start() {
        try {
            this.system = this.system.fork(new Option[]{CoreOptions.systemPackage((String)("org.ops4j.pax.exam;version=" + this.skipSnapshotFlag(Info.getPaxExamVersion()))), CoreOptions.systemPackage((String)("org.ops4j.pax.exam.options;version=" + this.skipSnapshotFlag(Info.getPaxExamVersion()))), CoreOptions.systemPackage((String)("org.ops4j.pax.exam.util;version=" + this.skipSnapshotFlag(Info.getPaxExamVersion()))), CoreOptions.systemProperty((String)"java.protocol.handler.pkgs").value("org.ops4j.pax.url")});
            Map<String, String> p = this.createFrameworkProperties();
            if (LOG.isDebugEnabled()) {
                this.logFrameworkProperties(p);
                this.logSystemProperties();
            }
            this.framework = this.frameworkFactory.newFramework(p);
            this.framework.init();
            this.framework.getBundleContext().addFrameworkListener(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent frameworkEvent) {
                    if (frameworkEvent.getType() == 2) {
                        LOG.error(String.format("Framework ERROR event %s", frameworkEvent.toString()), frameworkEvent.getThrowable());
                    } else {
                        LOG.debug(String.format("Framework event type %s: %s", FrameworkEventUtils.getFrameworkEventString((int)frameworkEvent.getType()), frameworkEvent.toString()), frameworkEvent.getThrowable());
                    }
                }
            });
            this.installAndStartBundles(this.framework.getBundleContext());
        }
        catch (BundleException e) {
            throw new TestContainerException("Problem starting test container.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TestContainerException("Problem starting test container.", (Throwable)e);
        }
        return this;
    }

    private void logFrameworkProperties(Map<String, String> p) {
        LOG.debug("==== Framework properties:");
        for (String key : p.keySet()) {
            LOG.debug("{} = {}", (Object)key, (Object)p.get(key));
        }
    }

    private void logSystemProperties() {
        LOG.debug("==== System properties:");
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
        for (Map.Entry entry : map.entrySet()) {
            LOG.debug("{} = {}", entry.getKey(), entry.getValue());
        }
    }

    public TestContainer stop() {
        if (this.framework != null) {
            try {
                this.cleanup();
                this.stopOrAbort();
                this.framework = null;
                this.system.clear();
            }
            catch (BundleException e) {
                LOG.warn("Problem during stopping fw.", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException during stopping fw.", (Throwable)e);
            }
        } else {
            LOG.warn("Framework does not exist. Called start() before ? ");
        }
        return this;
    }

    private void stopOrAbort() throws BundleException, InterruptedException {
        this.framework.stop();
        long timeout = this.system.getTimeout().getValue();
        Stopper stopper = new Stopper(timeout);
        stopper.start();
        stopper.join(timeout + 500L);
        if (this.framework.getState() != 4) {
            String message = "Framework has not yet stopped after " + timeout + " ms. waitForStop did not return";
            throw new TestContainerException(message);
        }
    }

    private Map<String, String> createFrameworkProperties() throws IOException {
        HashMap<String, String> p = new HashMap<String, String>();
        CleanCachesOption cleanCaches = (CleanCachesOption)this.system.getSingleOption(CleanCachesOption.class);
        if (cleanCaches != null && cleanCaches.getValue() != null && cleanCaches.getValue().booleanValue()) {
            p.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        p.put("org.osgi.framework.storage", this.system.getTempFolder().getAbsolutePath());
        p.put("org.osgi.framework.system.packages.extra", this.buildString((ValueOption[])this.system.getOptions(SystemPackageOption.class)));
        p.put("org.osgi.framework.bootdelegation", this.buildString((ValueOption[])this.system.getOptions(BootDelegationOption.class)));
        for (FrameworkPropertyOption frameworkPropertyOption : (FrameworkPropertyOption[])this.system.getOptions(FrameworkPropertyOption.class)) {
            p.put(frameworkPropertyOption.getKey(), (String)frameworkPropertyOption.getValue());
        }
        for (FrameworkPropertyOption frameworkPropertyOption : (SystemPropertyOption[])this.system.getOptions(SystemPropertyOption.class)) {
            System.setProperty(frameworkPropertyOption.getKey(), frameworkPropertyOption.getValue());
        }
        String repositories = this.buildString((ValueOption[])this.system.getOptions(RepositoryOption.class));
        if (!repositories.isEmpty()) {
            System.setProperty("org.ops4j.pax.url.mvn.repositories", repositories);
        }
        return p;
    }

    private String buildString(ValueOption<?>[] options) {
        return this.buildString(new String[0], options, new String[0]);
    }

    private String buildString(String[] prepend, ValueOption<?>[] options) {
        return this.buildString(prepend, options, new String[0]);
    }

    private String buildString(ValueOption<?>[] options, String[] append) {
        return this.buildString(new String[0], options, append);
    }

    private String buildString(String[] prepend, ValueOption<?>[] options, String[] append) {
        StringBuilder builder = new StringBuilder();
        for (String string : prepend) {
            builder.append(string);
            builder.append(",");
        }
        for (String string : options) {
            builder.append(string.getValue());
            builder.append(",");
        }
        for (String string : append) {
            builder.append(string);
            builder.append(",");
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    private void installAndStartBundles(BundleContext context) throws BundleException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (ProvisionOption bundle : (ProvisionOption[])this.system.getOptions(ProvisionOption.class)) {
            Bundle b = context.installBundle(bundle.getURL());
            bundles.add(b);
            int startLevel = this.getStartLevel(bundle);
            BundleStartLevel sl = (BundleStartLevel)b.adapt(BundleStartLevel.class);
            sl.setStartLevel(startLevel);
            if (bundle.shouldStart()) {
                try {
                    b.start();
                }
                catch (BundleException e) {
                    throw new BundleException("Error starting bundle " + b.getSymbolicName() + ". " + e.getMessage(), (Throwable)e);
                }
                LOG.debug("+ Install (start@{}) {}", (Object)startLevel, (Object)bundle);
                continue;
            }
            LOG.debug("+ Install (no start) {}", (Object)bundle);
        }
        this.framework.start();
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.framework.adapt(FrameworkStartLevel.class);
        this.setFrameworkStartLevel(context, fsl);
        this.verifyThatBundlesAreResolved(bundles);
    }

    private void setFrameworkStartLevel(BundleContext context, final FrameworkStartLevel sl) {
        FrameworkStartLevelOption startLevelOption = (FrameworkStartLevelOption)this.system.getSingleOption(FrameworkStartLevelOption.class);
        final int startLevel = startLevelOption == null ? 5 : startLevelOption.getStartLevel();
        LOG.debug("Jump to startlevel: " + startLevel);
        final CountDownLatch latch = new CountDownLatch(1);
        context.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                if (frameworkEvent.getType() == 8 && sl.getStartLevel() == startLevel) {
                    latch.countDown();
                }
            }
        });
        sl.setStartLevel(startLevel, new FrameworkListener[0]);
        if (sl.getStartLevel() == startLevel) {
            LOG.debug("requested start level reached");
            return;
        }
        LOG.debug("start level {} requested, current start level is {}", (Object)startLevel, (Object)sl.getStartLevel());
        try {
            long timeout = this.system.getTimeout().getValue();
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                if (startLevel != sl.getStartLevel()) {
                    String msg = String.format("start level %d has not been reached within %d ms", startLevel, timeout);
                    throw new TestContainerException(msg);
                }
                LOG.debug("requested start level reached");
            }
        }
        catch (InterruptedException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    private void verifyThatBundlesAreResolved(List<Bundle> bundles) {
        boolean hasUnresolvedBundles = false;
        for (Bundle bundle : bundles) {
            if (bundle.getState() != 2) continue;
            LOG.error("Bundle [{}] is not resolved", (Object)bundle);
            hasUnresolvedBundles = true;
        }
        ConfigurationManager cm = new ConfigurationManager();
        boolean failOnUnresolved = Boolean.parseBoolean(cm.getProperty("pax.exam.osgi.unresolved.fail", "false"));
        if (hasUnresolvedBundles && failOnUnresolved) {
            throw new TestContainerException("There are unresolved bundles. See previous ERROR log messages for details.");
        }
    }

    private int getStartLevel(ProvisionOption<?> bundle) {
        Integer start = bundle.getStartLevel();
        if (start == null) {
            start = 3;
        }
        return start;
    }

    private String skipSnapshotFlag(String version) {
        int idx = version.indexOf("-");
        if (idx >= 0) {
            return version.substring(0, idx);
        }
        return version;
    }

    public String toString() {
        return "Native:" + this.frameworkFactory.getClass().getSimpleName();
    }

    public synchronized long installProbe(InputStream stream) {
        this.probeId = this.install(stream);
        this.installed.pop();
        return this.probeId;
    }

    public synchronized void uninstallProbe() {
        Bundle bundle = this.framework.getBundleContext().getBundle(this.probeId.longValue());
        try {
            bundle.uninstall();
            this.probeId = null;
        }
        catch (BundleException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    private class Stopper
    extends Thread {
        private final long timeout;

        private Stopper(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                FrameworkEvent frameworkEvent = NativeTestContainer.this.framework.waitForStop(this.timeout);
                if (frameworkEvent.getType() != 64) {
                    LOG.error("Framework has not yet stopped after {} ms. waitForStop returned: {}", (Object)this.timeout, (Object)frameworkEvent);
                }
            }
            catch (InterruptedException exc) {
                LOG.error("Stopper thread was interrupted");
            }
        }
    }
}

