/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.DatabaseException;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.neo4j.ogm.driver.ParameterConversion;
import org.neo4j.ogm.drivers.bolt.driver.BoltEntityAdapter;
import org.neo4j.ogm.drivers.bolt.response.GraphModelResponse;
import org.neo4j.ogm.drivers.bolt.response.GraphRowModelResponse;
import org.neo4j.ogm.drivers.bolt.response.RestModelResponse;
import org.neo4j.ogm.drivers.bolt.response.RowModelResponse;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.RestModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.EmptyResponse;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltRequest
implements Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltRequest.class);
    private final TransactionManager transactionManager;
    private final ParameterConversion parameterConversion;
    private final BoltEntityAdapter entityAdapter;
    private final Function<String, String> cypherModification;

    public BoltRequest(TransactionManager transactionManager, ParameterConversion parameterConversion, BoltEntityAdapter entityAdapter, Function<String, String> cypherModification) {
        this.transactionManager = transactionManager;
        this.parameterConversion = parameterConversion;
        this.entityAdapter = entityAdapter;
        this.cypherModification = cypherModification;
    }

    public Response<GraphModel> execute(GraphModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphModelResponse(this.executeRequest((Statement)request), this.transactionManager, this.entityAdapter);
    }

    public Response<RowModel> execute(RowModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RowModelResponse(this.executeRequest((Statement)request), this.transactionManager, this.entityAdapter);
    }

    public Response<RowModel> execute(DefaultRequest query) {
        ArrayList<RowModel> rowModels = new ArrayList<RowModel>();
        String[] columns = null;
        for (Statement statement : query.getStatements()) {
            StatementResult result = this.executeRequest(statement);
            if (columns == null) {
                try {
                    List columnSet = result.keys();
                    columns = columnSet.toArray(new String[columnSet.size()]);
                }
                catch (ClientException e) {
                    throw new CypherException(e.code(), e.getMessage(), (Throwable)e);
                }
            }
            RowModelResponse rowModelResponse = new RowModelResponse(result, this.transactionManager, this.entityAdapter);
            Throwable throwable = null;
            try {
                RowModel model;
                while ((model = (RowModel)rowModelResponse.next()) != null) {
                    rowModels.add(model);
                }
                result.consume();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rowModelResponse == null) continue;
                if (throwable != null) {
                    try {
                        rowModelResponse.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rowModelResponse.close();
            }
        }
        return new MultiStatementBasedResponse(columns, rowModels);
    }

    public Response<GraphRowListModel> execute(GraphRowListModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphRowModelResponse(this.executeRequest((Statement)request), this.transactionManager, this.entityAdapter);
    }

    public Response<RestModel> execute(RestModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RestModelResponse(this.executeRequest((Statement)request), this.transactionManager, this.entityAdapter);
    }

    private StatementResult executeRequest(Statement request) {
        try {
            Map parameterMap = this.parameterConversion.convertParameters(request.getParameters());
            String cypher = this.cypherModification.apply(request.getStatement());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Request: {} with params {}", (Object)cypher, (Object)parameterMap);
            }
            BoltTransaction tx = (BoltTransaction)this.transactionManager.getCurrentTransaction();
            return tx.nativeBoltTransaction().run(cypher, parameterMap);
        }
        catch (ClientException | DatabaseException | TransientException ce) {
            throw new CypherException(ce.code(), ce.getMessage(), ce);
        }
    }

    private static class MultiStatementBasedResponse
    implements Response<RowModel> {
        private final String[] columns;
        private final List<RowModel> rowModels;
        private int currentRow = 0;

        MultiStatementBasedResponse(String[] columns, List<RowModel> rowModels) {
            this.columns = columns;
            this.rowModels = rowModels;
        }

        public RowModel next() {
            if (this.currentRow < this.rowModels.size()) {
                return this.rowModels.get(this.currentRow++);
            }
            return null;
        }

        public void close() {
        }

        public String[] columns() {
            return this.columns;
        }
    }
}

