/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.codec;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.mydotey.codec.Codec;

public abstract class AbstractCodec
implements Codec {
    @Override
    public byte[] encode(Object obj) {
        Objects.requireNonNull(obj, "obj is null");
        return this.doEncode(obj);
    }

    @Override
    public <T> T decode(byte[] is, Class<T> clazz) {
        Objects.requireNonNull(is, "is is null");
        Objects.requireNonNull(clazz, "clazz is null");
        return this.doDecode(is, clazz);
    }

    @Override
    public void encode(OutputStream os, Object obj) {
        Objects.requireNonNull(os, "os is null");
        Objects.requireNonNull(obj, "obj is null");
        this.doEncode(os, obj);
    }

    @Override
    public <T> T decode(InputStream is, Class<T> clazz) {
        Objects.requireNonNull(is, "is is null");
        Objects.requireNonNull(clazz, "clazz is null");
        return this.doDecode(is, clazz);
    }

    protected abstract byte[] doEncode(Object var1);

    protected abstract <T> T doDecode(byte[] var1, Class<T> var2);

    protected abstract void doEncode(OutputStream var1, Object var2);

    protected abstract <T> T doDecode(InputStream var1, Class<T> var2);
}

