/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jooq.codegen.GenerationTool;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Logging;
import org.jooq.meta.jaxb.Target;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class Plugin
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="jooq.codegen.configurationFile")
    private String configurationFile;
    @Parameter(property="jooq.codegen.skip")
    private boolean skip;
    @Parameter(property="jooq.codegen.logging")
    private Logging logging;
    @Parameter
    private Jdbc jdbc;
    @Parameter
    private Generator generator;

    public void execute() throws MojoExecutionException {
        Configuration configuration;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping jOOQ code generation");
            return;
        }
        if (this.configurationFile != null) {
            this.getLog().info((CharSequence)"Reading external configuration");
            File file = new File(this.configurationFile);
            if (!file.isAbsolute()) {
                file = new File(this.project.getBasedir(), this.configurationFile);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                configuration = GenerationTool.load((InputStream)in);
                this.generator = configuration.getGenerator();
                this.jdbc = configuration.getJdbc();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.generator == null) {
            this.getLog().error((CharSequence)"Incorrect configuration of jOOQ code generation tool");
            this.getLog().error((CharSequence)"\nThe jOOQ-codegen-maven module's generator configuration is not set up correctly.\nThis can have a variety of reasons, among which:\n- Your pom.xml's <configuration> contains invalid XML according to jooq-codegen-3.11.0.xsd\n- There is a version or artifact mismatch between your pom.xml and your commandline");
            throw new MojoExecutionException("Incorrect configuration of jOOQ code generation tool. See error above for details.");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader pluginClassLoader = this.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            if (this.generator.getTarget() == null) {
                this.generator.setTarget(new Target());
            }
            if (this.generator.getTarget().getDirectory() == null) {
                this.generator.getTarget().setDirectory("target/generated-sources/jooq");
            }
            if (!new File(this.generator.getTarget().getDirectory()).isAbsolute()) {
                this.generator.getTarget().setDirectory(new File(this.project.getBasedir(), this.generator.getTarget().getDirectory()).getCanonicalPath());
            }
            configuration = new Configuration();
            configuration.setLogging(this.logging);
            configuration.setJdbc(this.jdbc);
            configuration.setGenerator(this.generator);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using this configuration:\n" + configuration));
            }
            GenerationTool.generate((Configuration)configuration);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            try {
                pluginClassLoader.close();
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"Couldn't close the classloader.", e);
            }
        }
        this.project.addCompileSourceRoot(this.generator.getTarget().getDirectory());
    }

    private URLClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }
}

