/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import java.awt.Dimension;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.filter.text.AbstractTextContentInserterFilter;
import org.jodconverter.office.OfficeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInserterFilter
extends AbstractTextContentInserterFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextInserterFilter.class);
    private final String insertedText;

    public TextInserterFilter(String text, int width, int height, int horizontalPosition, int verticalPosition) {
        super(new Dimension(width, height), horizontalPosition, verticalPosition);
        Validate.notBlank((CharSequence)text);
        this.insertedText = text;
    }

    public TextInserterFilter(String text, int width, int height, Map<String, Object> shapeProperties) {
        super(new Dimension(width, height), shapeProperties);
        Validate.notBlank((CharSequence)text);
        this.insertedText = text;
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        XTextDocument docText = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)document);
        XMultiServiceFactory docServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)docText);
        XTextFrame textFrame = (XTextFrame)UnoRuntime.queryInterface(XTextFrame.class, (Object)docServiceFactory.createInstance("com.sun.star.text.TextFrame"));
        XShape shape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)textFrame);
        shape.setSize(TextInserterFilter.toOfficeSize(this.getRectSize()));
        XPropertySet propSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textFrame);
        for (Map.Entry<String, Object> entry : this.getShapeProperties().entrySet()) {
            propSet.setPropertyValue(entry.getKey(), entry.getValue());
        }
        XText text = docText.getText();
        XTextCursor textCursor = text.createTextCursor();
        this.applyAnchorPageNoFix(docText, textCursor);
        LOGGER.debug("Inserting frame into the document");
        text.insertTextContent((XTextRange)textCursor, (XTextContent)textFrame, false);
        text = textFrame.getText();
        textCursor = text.createTextCursor();
        LOGGER.debug("Writing text to the inserted frame");
        text.insertString((XTextRange)textCursor, this.insertedText, false);
        chain.doFilter(context, document);
    }
}

