/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmDefaultsInHierarchy", "", "enableJvmDefault", "frontend.java"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean bl;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Collection destination$iv$iv;
        JvmDefaultMode jvmDefaultMode;
        block25: {
            boolean $i$f$any;
            Iterable $this$any$iv;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            jvmDefaultMode = context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
            AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME());
            if (annotationDescriptor != null) {
                KtElement reportOn;
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                boolean bl2 = false;
                boolean bl3 = false;
                AnnotationDescriptor annotationDescriptor3 = annotationDescriptor2;
                boolean bl4 = false;
                KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor3);
                KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
                if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                    context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_NOT_IN_INTERFACE.on(reportOn));
                } else if (this.jvmTarget == JvmTarget.JVM_1_6) {
                    context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn));
                } else if (!jvmDefaultMode.isEnabled()) {
                    context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtDeclaration)((PsiElement)declaration2)));
                }
                return;
            }
            if (descriptor2 instanceof ClassDescriptor) {
                boolean hasDeclaredJvmDefaults;
                block24: {
                    boolean bl2;
                    Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
                    boolean $i$f$filterIsInstance = false;
                    Iterable annotationDescriptor3 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    Iterator<Object> iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv = iterator2.next();
                        if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$any$iv = (List)destination$iv$iv;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                            boolean bl6 = false;
                            CallableMemberDescriptor.Kind kind = it.getKind();
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind), (String)"it.kind");
                            if (!(kind.isReal() && JvmAnnotationUtilKt.hasJvmDefaultAnnotation(it))) continue;
                            bl2 = true;
                            break block24;
                        }
                        bl2 = hasDeclaredJvmDefaults = false;
                    }
                }
                if (!hasDeclaredJvmDefaults && !this.checkJvmDefaultsInHierarchy(descriptor2, jvmDefaultMode.isEnabled())) {
                    context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_THROUGH_INHERITANCE.on((KtDeclaration)((PsiElement)declaration2)));
                }
            }
            if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                declarationDescriptor = null;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
            if (callableMemberDescriptor == null) {
                return;
            }
            CallableMemberDescriptor memberDescriptor = callableMemberDescriptor;
            if (descriptor2 instanceof PropertyAccessorDescriptor) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"memberDescriptor.overriddenDescriptors");
            $this$any$iv = collection;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl7 = false;
                    if (!it.getAnnotations().hasAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME())) continue;
                    bl = true;
                    break block25;
                }
                bl = false;
            }
        }
        if (bl) {
            context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_REQUIRED_FOR_OVERRIDE.on((KtDeclaration)((PsiElement)declaration2)));
        } else if (jvmDefaultMode.isEnabled()) {
            void $this$flatMapTo$iv$iv;
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.overriddenDescriptors");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                boolean bl8 = false;
                Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations(it);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"OverridingUtil.getOverriddenDeclarations(it)");
                Iterable list$iv$iv = set;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            boolean bl9 = false;
            boolean bl10 = false;
            Set it = set;
            boolean bl11 = false;
            for (CallableMemberDescriptor realDescriptor : OverridingUtil.filterOutOverridden(it)) {
                if (!(realDescriptor instanceof JavaMethodDescriptor) || ((JavaMethodDescriptor)realDescriptor).getModality() == Modality.ABSTRACT) continue;
                context2.getTrace().report(ErrorsJvm.NON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT.on((KtDeclaration)((PsiElement)declaration2)));
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkJvmDefaultsInHierarchy(DeclarationDescriptor descriptor2, boolean enableJvmDefault) {
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        if (enableJvmDefault) {
            return true;
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return true;
        }
        Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$all$iv = (List)destination$iv$iv;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        object = $this$all$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)element$iv;
            boolean bl2 = false;
            CallableMemberDescriptor.Kind kind = memberDescriptor.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind), (String)"memberDescriptor.kind");
            if (!kind.isReal()) {
                boolean bl3;
                Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"memberDescriptor.overriddenDescriptors");
                Set set = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)collection));
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"OverridingUtil.filterOut\u2026iddenDescriptors.toSet())");
                Iterable $this$all$iv2 = set;
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv2;
                        boolean bl4 = false;
                        CallableMemberDescriptor callableMemberDescriptor = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
                        if (DescriptorUtils.isInterface(callableMemberDescriptor.getContainingDeclaration()) && JvmAnnotationUtilKt.hasJvmDefaultAnnotation(it)) {
                            if (it.getModality() != Modality.ABSTRACT) return false;
                        }
                        boolean bl5 = true;
                        if (bl5) continue;
                        return false;
                    }
                    bl3 = true;
                }
                if (!bl3) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public JvmDefaultChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkParameterIsNotNull((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }
}

