/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0011\u001a\u00020\u000e\"\n\b\u0000\u0010\u0012*\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00160\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0018\u001a\u00020\u000e\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0016J(\u0010\u001a\u001a\u00020\u000e\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0016J2\u0010\u001b\u001a\u00020\u000e\"\n\b\u0000\u0010\u0012*\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00160\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0016J \u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J2\u0010,\u001a\u00020\u000e\"\n\b\u0000\u0010\u0012*\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00160\u0015H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010.\u001a\u00020\u000e2\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J.\u00107\u001a\u00020\u000e\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u001609H\u0016J \u0010:\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00104\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J \u0010>\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J,\u0010A\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020D2\n\u0010E\u001a\u0006\u0012\u0002\b\u000300H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForImplicitConstructorDelegationCall;", "Lorg/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy;", "delegationCall", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "(Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;Lorg/jetbrains/kotlin/psi/Call;)V", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationReferenceExpression;", "getCalleeExpression", "()Lorg/jetbrains/kotlin/psi/KtConstructorDelegationReferenceExpression;", "getDelegationCall", "()Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "abstractSuperCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "ambiguity", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptors", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "bindCall", "bindReference", "resolvedCall", "bindResolvedCall", "cannotCompleteResolve", "instantiationOfAbstractClass", "invisibleMember", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "missingReceiver", "expectedReceiver", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "nestedClassAccessViaInstanceReference", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "noReceiverAllowed", "noValueForParameter", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "noneApplicable", "reportError", "typeInferenceFailed", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "data", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "unexpectedError", "type", "", "unresolvedReference", "unresolvedReferenceWrongReceiver", "candidates", "", "unsafeCall", "Lorg/jetbrains/kotlin/types/KotlinType;", "isCallForImplicitInvoke", "", "wrongNumberOfTypeArguments", "expectedTypeArgumentCount", "", "wrongReceiverType", "receiverParameter", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "c", "frontend"})
public final class TracingStrategyForImplicitConstructorDelegationCall
extends AbstractTracingStrategy {
    @Nullable
    private final KtConstructorDelegationReferenceExpression calleeExpression;
    @NotNull
    private final KtConstructorDelegationCall delegationCall;

    @Nullable
    public final KtConstructorDelegationReferenceExpression getCalleeExpression() {
        return this.calleeExpression;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        trace.record(BindingContext.CALL, call2.getCalleeExpression(), call2);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        D descriptor2 = resolvedCall2.getCandidateDescriptor();
        DeclarationDescriptor storedReference = (DeclarationDescriptor)trace.get(BindingContext.REFERENCE_TARGET, this.calleeExpression);
        if (storedReference == null || !ErrorUtils.isError((DeclarationDescriptor)descriptor2)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.calleeExpression, descriptor2);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall2);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = this.calleeExpression;
        if (ktConstructorDelegationReferenceExpression == null) {
            Intrinsics.throwNpe();
        }
        trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)ktConstructorDelegationReferenceExpression), this.calleeExpression));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on(this.reference, candidates2));
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)valueParameter, (String)"valueParameter");
        this.reportError(trace);
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        this.reportError(trace);
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        this.reportError(trace);
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.reportError(trace);
    }

    private final void reportError(BindingTrace trace) {
        boolean bl;
        block4: {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
            Iterable $this$any$iv = bindingContext.getDiagnostics().forElement(this.delegationCall);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getFactory(), Errors.EXPLICIT_DELEGATION_CALL_REQUIRED)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            trace.report(Errors.EXPLICIT_DELEGATION_CALL_REQUIRED.on((KtConstructorDelegationCall)((PsiElement)this.delegationCall)));
        }
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        this.unexpectedError("cannotCompleteResolve");
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.unexpectedError("instantiationOfAbstractClass");
    }

    @Override
    public void abstractSuperCall(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.unexpectedError("abstractSuperCall");
    }

    @Override
    public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor2, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)explicitReceiverKind), (String)"explicitReceiverKind");
        this.unexpectedError("nestedClassAccessViaInstanceReference");
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        this.unexpectedError("unsafeCall");
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)expectedReceiver, (String)"expectedReceiver");
        this.unexpectedError("missingReceiver");
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkParameterIsNotNull((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        this.unexpectedError("wrongReceiverType");
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.unexpectedError("noReceiverAllowed");
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.unexpectedError("wrongNumberOfTypeArguments");
    }

    @Override
    public void typeInferenceFailed(@NotNull ResolutionContext<?> context, @NotNull InferenceErrorData data) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.unexpectedError("typeInferenceFailed");
    }

    private final void unexpectedError(String type2) {
        throw (Throwable)((Object)new AssertionError((Object)("Unexpected error type: " + type2)));
    }

    @NotNull
    public final KtConstructorDelegationCall getDelegationCall() {
        return this.delegationCall;
    }

    public TracingStrategyForImplicitConstructorDelegationCall(@NotNull KtConstructorDelegationCall delegationCall, @NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull((Object)delegationCall, (String)"delegationCall");
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = delegationCall.getCalleeExpression();
        if (ktConstructorDelegationReferenceExpression == null) {
            Intrinsics.throwNpe();
        }
        super(ktConstructorDelegationReferenceExpression, call2);
        this.delegationCall = delegationCall;
        this.calleeExpression = this.delegationCall.getCalleeExpression();
    }
}

