/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InfixCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class InfixCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        ResolvedCall<?> resolvedCall3;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof FunctionDescriptor)) {
            obj = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (functionDescriptor2.isInfix() || DynamicCallsKt.isDynamic(functionDescriptor2) || ErrorUtils.isError(functionDescriptor2)) {
            return;
        }
        ResolvedCall<?> resolvedCall4 = resolvedCall2;
        if (!(resolvedCall4 instanceof VariableAsFunctionResolvedCall)) {
            resolvedCall4 = null;
        }
        if ((resolvedCall3 = (VariableAsFunctionResolvedCall)((Object)resolvedCall4)) == null || (resolvedCall3 = resolvedCall3.getVariableCall()) == null) {
            resolvedCall3 = resolvedCall2;
        }
        Call call2 = resolvedCall3.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"((resolvedCall as? Varia\u2026all ?: resolvedCall).call");
        Call call3 = call2;
        if (CallResolverUtilKt.isInfixCall(call3)) {
            DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"functionDescriptor.containingDeclaration");
            String string = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"functionDescriptor.conta\u2026n.fqNameUnsafe.asString()");
            String containingDeclarationName = string;
            context.getTrace().report(Errors.INFIX_MODIFIER_REQUIRED.on(reportOn, functionDescriptor2, containingDeclarationName));
        }
    }
}

