/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.MemberHolder;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Parameter;

public interface MethodHolder<O extends JavaType<O>>
extends MemberHolder<O> {
    default public boolean hasMethod(Method<O, ?> name) {
        return this.getMethods().contains(name);
    }

    default public boolean hasMethodSignature(Method<?, ?> method) {
        for (Method<O, ?> local : this.getMethods()) {
            if (!local.getName().equals(method.getName())) continue;
            Iterator<Parameter<O>> localParams = local.getParameters().iterator();
            for (Parameter<?> methodParam : method.getParameters()) {
                if (localParams.hasNext() && Objects.equals(localParams.next().getType().getName(), methodParam.getType().getName())) continue;
                return false;
            }
            return !localParams.hasNext();
        }
        return false;
    }

    default public boolean hasMethodSignature(String name) {
        return this.hasMethodSignature(name, new String[0]);
    }

    default public boolean hasMethodSignature(String name, String ... paramTypes) {
        return this.getMethod(name, paramTypes) != null;
    }

    default public boolean hasMethodSignature(String name, Class<?> ... paramTypes) {
        String[] types = paramTypes == null ? new String[]{} : (String[])Arrays.stream(paramTypes).map(Class::getName).toArray(String[]::new);
        return this.hasMethodSignature(name, types);
    }

    default public Method<O, ?> getMethod(String name) {
        for (Method<O, ?> method : this.getMethods()) {
            if (!method.getName().equals(name) || method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    public Method<O, ?> getMethod(String var1, String ... var2);

    public Method<O, ?> getMethod(String var1, Class<?> ... var2);

    public List<? extends Method<O, ?>> getMethods();
}

