/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.mapper.orm.logging.impl.HibernateOrmEventContextMessages;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchIndexingWorkspace;
import org.hibernate.search.mapper.orm.massindexing.impl.FailureHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;

public class BatchCoordinator
extends FailureHandledRunnable {
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final DetachedBackendSessionContext sessionContext;
    private final List<MassIndexingIndexedTypeGroup<?>> typeGroupsToIndex;
    private final PojoScopeSchemaManager scopeSchemaManager;
    private final PojoScopeWorkspace scopeWorkspace;
    private final int typesToIndexInParallel;
    private final int documentBuilderThreads;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final boolean mergeSegmentsOnFinish;
    private final boolean dropAndCreateSchemaOnStart;
    private final boolean purgeAtStart;
    private final boolean mergeSegmentsAfterPurge;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final List<CompletableFuture<?>> indexingFutures = new ArrayList();

    BatchCoordinator(HibernateOrmMassIndexingMappingContext mappingContext, DetachedBackendSessionContext sessionContext, MassIndexingNotifier notifier, List<MassIndexingIndexedTypeGroup<?>> typeGroupsToIndex, PojoScopeSchemaManager scopeSchemaManager, PojoScopeWorkspace scopeWorkspace, int typesToIndexInParallel, int documentBuilderThreads, CacheMode cacheMode, int objectLoadingBatchSize, long objectsLimit, boolean mergeSegmentsOnFinish, boolean dropAndCreateSchemaOnStart, boolean purgeAtStart, boolean mergeSegmentsAfterPurge, int idFetchSize, Integer transactionTimeout) {
        super(notifier);
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.typeGroupsToIndex = typeGroupsToIndex;
        this.scopeSchemaManager = scopeSchemaManager;
        this.scopeWorkspace = scopeWorkspace;
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.documentBuilderThreads = documentBuilderThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.mergeSegmentsOnFinish = mergeSegmentsOnFinish;
        this.dropAndCreateSchemaOnStart = dropAndCreateSchemaOnStart;
        this.purgeAtStart = purgeAtStart;
        this.mergeSegmentsAfterPurge = mergeSegmentsAfterPurge;
        this.objectsLimit = objectsLimit;
    }

    @Override
    public void runWithFailureHandler() throws InterruptedException {
        if (!this.indexingFutures.isEmpty()) {
            throw new AssertionFailure("BatchCoordinator instance not expected to be reused");
        }
        this.beforeBatch();
        this.doBatchWork();
        this.afterBatch();
    }

    @Override
    protected void cleanUpOnInterruption() throws InterruptedException {
        this.cancelPendingTasks();
        this.afterBatchOnInterruption();
    }

    @Override
    protected void cleanUpOnFailure() {
        this.cancelPendingTasks();
    }

    @Override
    protected void notifySuccess() {
        this.getNotifier().notifyIndexingCompletedSuccessfully();
    }

    @Override
    protected void notifyInterrupted(InterruptedException exception) {
        this.getNotifier().notifyIndexingCompletedWithInterruption();
    }

    @Override
    protected void notifyFailure(RuntimeException exception) {
        this.getNotifier().notifyIndexingCompletedWithFailure(exception);
    }

    private void cancelPendingTasks() {
        for (Future future : this.indexingFutures) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
    }

    private void doBatchWork() throws InterruptedException {
        ThreadPoolExecutor executor = this.mappingContext.threadPoolProvider().newFixedThreadPool(this.typesToIndexInParallel, "Mass indexing - Workspace");
        for (MassIndexingIndexedTypeGroup<?> typeGroup : this.typeGroupsToIndex) {
            this.indexingFutures.add(Futures.runAsync(this.createBatchIndexingWorkspace(typeGroup), (ExecutorService)executor));
        }
        executor.shutdown();
        Futures.unwrappedExceptionGet(CompletableFuture.allOf(this.indexingFutures.toArray(new CompletableFuture[0])));
    }

    private <E> BatchIndexingWorkspace<E, ?> createBatchIndexingWorkspace(MassIndexingIndexedTypeGroup<E> typeGroup) {
        return new BatchIndexingWorkspace(this.mappingContext, this.sessionContext, this.getNotifier(), typeGroup.commonSuperType(), typeGroup.idAttribute(), typeGroup.includedIndexedTypesOrEmpty(), this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.objectsLimit, this.idFetchSize, this.transactionTimeout);
    }

    private void afterBatch() throws InterruptedException {
        if (this.mergeSegmentsOnFinish) {
            Futures.unwrappedExceptionGet((Future)this.scopeWorkspace.mergeSegments());
        }
        Futures.unwrappedExceptionGet((Future)this.scopeWorkspace.flush());
        Futures.unwrappedExceptionGet((Future)this.scopeWorkspace.refresh());
    }

    private void afterBatchOnInterruption() throws InterruptedException {
        Futures.unwrappedExceptionGet((Future)this.scopeWorkspace.flush());
        Futures.unwrappedExceptionGet((Future)this.scopeWorkspace.refresh());
    }

    private void beforeBatch() throws InterruptedException {
        if (this.dropAndCreateSchemaOnStart) {
            RootFailureCollector failureCollector = new RootFailureCollector(HibernateOrmEventContextMessages.INSTANCE.schemaManagement());
            Futures.unwrappedExceptionGet((Future)this.scopeSchemaManager.dropAndCreate((FailureCollector)failureCollector));
            failureCollector.checkNoFailure();
        }
        if (this.purgeAtStart) {
            Futures.unwrappedExceptionGet((Future)this.scopeWorkspace.purge(Collections.emptySet()));
            if (this.mergeSegmentsAfterPurge) {
                Futures.unwrappedExceptionGet((Future)this.scopeWorkspace.mergeSegments());
            }
        }
    }
}

