/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractHibernateOrmTypeContext<E>
implements HibernateOrmScopeTypeContext<E>,
HibernateOrmListenerTypeContext,
HibernateOrmSessionTypeContext<E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeIdentifier<E> typeIdentifier;
    private final String jpaEntityName;
    private final EntityPersister entityPersister;
    private final EntityTypeDescriptor<E> entityTypeDescriptor;

    AbstractHibernateOrmTypeContext(SessionFactoryImplementor sessionFactory, PojoRawTypeIdentifier<E> typeIdentifier, String jpaEntityName, String hibernateOrmEntityName) {
        this.typeIdentifier = typeIdentifier;
        this.jpaEntityName = jpaEntityName;
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        this.entityPersister = metamodel.entityPersister(hibernateOrmEntityName);
        this.entityTypeDescriptor = metamodel.entity(this.entityPersister.getEntityName());
    }

    public String toString() {
        return this.typeIdentifier().toString();
    }

    @Override
    public PojoRawTypeIdentifier<E> typeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public String jpaEntityName() {
        return this.jpaEntityName;
    }

    public String hibernateOrmEntityName() {
        return this.entityPersister.getEntityName();
    }

    public EntityPersister entityPersister() {
        return this.entityPersister;
    }

    public EntityTypeDescriptor<E> entityTypeDescriptor() {
        if (this.entityTypeDescriptor == null) {
            throw log.nonJpaEntityType(this.typeIdentifier);
        }
        return this.entityTypeDescriptor;
    }
}

