/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibCSupport;
import com.oracle.svm.core.windows.headers.WindowsLibC;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredImageSingleton(value={LibCSupport.class})
class WindowsLibCSupport
implements LibCSupport {
    WindowsLibCSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int errno() {
        return WindowsLibC._errno().read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setErrno(int value) {
        WindowsLibC._errno().write(value);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T memcpy(T dest, PointerBase src, UnsignedWord n) {
        return WindowsLibC.memcpy(dest, src, n);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T memmove(T dest, PointerBase src, UnsignedWord n) {
        return WindowsLibC.memmove(dest, src, n);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T memset(T s, SignedWord c, UnsignedWord n) {
        return WindowsLibC.memset(s, c, n);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T malloc(UnsignedWord size) {
        return WindowsLibC.malloc(size);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T calloc(UnsignedWord nmemb, UnsignedWord size) {
        return WindowsLibC.calloc(nmemb, size);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T realloc(PointerBase ptr, UnsignedWord size) {
        return WindowsLibC.realloc(ptr, size);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void free(PointerBase ptr) {
        WindowsLibC.free(ptr);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void exit(int status) {
        WindowsLibC.exit(status);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord strlen(CCharPointer str) {
        return WindowsLibC.strlen(str);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int strcmp(CCharPointer s1, CCharPointer s2) {
        return WindowsLibC.strcmp((PointerBase)s1, (PointerBase)s2);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int isdigit(int c) {
        return WindowsLibC.isdigit(c);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord strtoull(CCharPointer string, CCharPointerPointer endPtr, int base) {
        return WindowsLibC.strtoull(string, endPtr, base);
    }
}

