/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;

public abstract class NonBytecodeStaticMethod
implements GraphProvider,
ResolvedJavaMethod {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final LineNumberTable lineNumberTable = new LineNumberTable(new int[]{1}, new int[]{0});
    private final String name;
    private final ResolvedJavaType declaringClass;
    private final Signature signature;
    private final ConstantPool constantPool;
    private StackTraceElement stackTraceElement;

    public NonBytecodeStaticMethod(String name, ResolvedJavaType declaringClass, Signature signature, ConstantPool constantPool) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.signature = signature;
        this.constantPool = constantPool;
    }

    public boolean allowRuntimeCompilation() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.declaringClass;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        throw VMError.unimplemented();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public int getMaxLocals() {
        return 2 * this.getSignature().getParameterCount(true);
    }

    public int getMaxStackSize() {
        return 2;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    public boolean isBridge() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isClassInitializer() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean canBeStaticallyBound() {
        return true;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return new ExceptionHandler[0];
    }

    public StackTraceElement asStackTraceElement(int bci) {
        if (this.stackTraceElement == null) {
            this.stackTraceElement = new StackTraceElement(this.getDeclaringClass().toJavaName(true), this.getName(), "generated", 0);
        }
        return this.stackTraceElement;
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.unimplemented();
    }

    public void reprofile() {
        throw VMError.unimplemented();
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.unimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw VMError.unimplemented();
    }

    public boolean canBeInlined() {
        return false;
    }

    public boolean hasNeverInlineDirective() {
        return false;
    }

    public boolean shouldBeInlined() {
        return false;
    }

    public LineNumberTable getLineNumberTable() {
        return lineNumberTable;
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.unimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.unimplemented();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return NO_ANNOTATIONS;
    }

    public Annotation[] getDeclaredAnnotations() {
        return NO_ANNOTATIONS;
    }

    public int getModifiers() {
        return 9;
    }
}

