/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent.jdk8;

import com.oracle.svm.hosted.agent.NativeImageBytecodeInstrumentationAgentExtension;
import com.oracle.svm.hosted.agent.jdk8.lambda.LambdaMetaFactoryRewriteVisitor;
import com.oracle.svm.util.AgentSupport;
import com.oracle.svm.util.TransformerInterface;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;

public class NativeImageBytecodeInstrumentationAgentJDK8
implements NativeImageBytecodeInstrumentationAgentExtension {
    @Override
    public void addClassFileTransformers(Instrumentation inst) {
        if (!System.getProperty("java.specification.version").equals("1.8")) {
            return;
        }
        TransformerInterface transformation = NativeImageBytecodeInstrumentationAgentJDK8::applyRewriteLambdasTransformation;
        ClassFileTransformer transformer = AgentSupport.createClassInstrumentationTransformer((TransformerInterface)transformation);
        inst.addTransformer(transformer);
    }

    private static byte[] applyRewriteLambdasTransformation(String moduleName, ClassLoader loader, String className, byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassWriter writer = new ClassWriter(reader, 1);
        LambdaMetaFactoryRewriteVisitor visitor = new LambdaMetaFactoryRewriteVisitor(loader, className, writer);
        reader.accept(visitor, 8);
        return writer.toByteArray();
    }
}

