/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class SingleThreadedVMMutex
extends VMMutex {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SingleThreadedVMMutex(String name) {
        super(name);
    }

    @Override
    public VMMutex lock() {
        this.assertNotOwner("Recursive locking is not supported");
        this.setOwnerToCurrentThread();
        return this;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true, callerMustBe=true)
    public void lockNoTransition() {
        this.assertNotOwner("Recursive locking is not supported");
        this.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true, callerMustBe=true)
    public void lockNoTransitionUnspecifiedOwner() {
        this.setOwnerToUnspecified();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlock() {
        this.clearCurrentThreadOwner();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlockNoTransitionUnspecifiedOwner() {
        this.clearUnspecifiedOwner();
    }

    @Override
    public void unlockWithoutChecks() {
        this.clearCurrentThreadOwner();
    }
}

