/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.FileSystemProviderSupport;
import com.oracle.svm.core.jdk.JRTSupport;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class FileSystemProviderFeature
implements Feature {
    FileSystemProviderFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ArrayList<FileSystemProvider> installedProviders = new ArrayList<FileSystemProvider>();
        if (FileSystemProviderSupport.Options.AddAllFileSystemProviders.getValue().booleanValue()) {
            installedProviders.addAll(FileSystemProvider.installedProviders());
        }
        ImageSingletons.add(FileSystemProviderSupport.class, (Object)new FileSystemProviderSupport(installedProviders));
        if (!JRTSupport.Options.AllowJRTFileSystem.getValue().booleanValue()) {
            FileSystemProviderSupport.remove("jrt");
        }
    }
}

