/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

public enum ConfigurationFile {
    DYNAMIC_PROXY("proxy", true),
    RESOURCES("resource", true),
    JNI("jni", true),
    REFLECTION("reflect", true),
    SERIALIZATION("serialization", true),
    SERIALIZATION_DENY("serialization-deny", false),
    PREDEFINED_CLASSES_NAME("predefined-classes", true);

    private static final String DEFAULT_FILE_NAME_SUFFIX = "-config.json";
    private final String fileName;
    private final boolean canAgentGenerate;
    public static final String PREDEFINED_CLASSES_AGENT_EXTRACTED_SUBDIR = "agent-extracted-predefined-classes";
    public static final String PREDEFINED_CLASSES_AGENT_EXTRACTED_NAME_SUFFIX = ".classdata";

    private ConfigurationFile(String fileName, boolean canAgentGenerate) {
        this.fileName = fileName;
        this.canAgentGenerate = canAgentGenerate;
    }

    public String getFileName() {
        return this.fileName + DEFAULT_FILE_NAME_SUFFIX;
    }

    public String getFileName(String suffix) {
        return this.fileName + suffix;
    }

    public boolean canBeGeneratedByAgent() {
        return this.canAgentGenerate;
    }
}

