/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.Uninterruptible;
import java.util.function.Supplier;

public final class RingBuffer<T> {
    private static int defaultBufferSize = 30;
    private final T[] entries;
    private int pos;
    private boolean wrapped;

    public RingBuffer() {
        this(defaultBufferSize);
    }

    public RingBuffer(int numEntries) {
        this.entries = new Object[numEntries];
    }

    public RingBuffer(int numEntries, Supplier<T> supplier) {
        this(numEntries);
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = supplier.get();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private int nextIndex(int p) {
        return (p + 1) % this.entries.length;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void append(T entry) {
        this.entries[this.pos] = entry;
        this.advance();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void advance() {
        int posNext = this.nextIndex(this.pos);
        if (posNext <= this.pos) {
            this.wrapped = true;
        }
        this.pos = posNext;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public T next() {
        T result = this.entries[this.pos];
        this.advance();
        return result;
    }

    public void foreach(Consumer<T> consumer) {
        this.foreach(null, consumer);
    }

    public void foreach(Object context, Consumer<T> consumer) {
        if (this.wrapped) {
            int i = this.pos;
            do {
                consumer.accept(context, this.entries[i]);
            } while ((i = this.nextIndex(i)) != this.pos);
        } else {
            for (int i = 0; i < this.pos; ++i) {
                consumer.accept(context, this.entries[i]);
            }
        }
    }

    public static interface Consumer<T> {
        public void accept(Object var1, T var2);
    }
}

